%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Latest update: 16 October 2025
%Brian Fournet
%bpfournet@gmail.com

% **gatech-thesis.cls**

    % * Signatures:
    %   * Right-anchored single-column layout; “APPROVED:” flush-right at top
    %   * Chair always first; Dean always last (Dean forced to RIGHT); updated `\place@sig` to balance LEFT/RIGHT and cap LEFT via `\maxleft`
    %   * Safe-pop/print helpers to avoid blank rows; fixed `#` parameter errors (`##`) in macro defs
    %   * Two-column threshold set at ≥5 signatures (newer rule retained)
    %   * Increased single-column capacity and added reader macros to support large committees (`\twelfthreader` … `\sixteenthreader`)
    %   * Predictive balancing (even growth with Dean reserved on RIGHT); per-signature blocks right-aligned (`\raggedleft`)
    %   * Replaced outer `center` with `\noindent\signature@body` for stable placement
    %   * Replaced fixed pre-signature space with flexible glue: `\vspace*{2\baselineskip plus 1fill}`
    
    % * Copyright:
    %   * Bottom-anchored layout (`\vspace*{\fill}` … content … `\vspace*{\fill}`) with local nudge `\vspace*{-0.20in}` (alt: `\enlargethispage{0.20in}`)
    %   * Block set to single-spaced locally; tightened vertical spacing
    %   * Added rule between author name and year (`\rule{...}{...}`/` \hrulefill`)
    
    % * Headings:
    %   * Added `\vspace*{\baselineskip}` after `\@makechapterhead` (space below chapter titles)
    
    % * Dedication/Epigraph:
    %   * Restored roman-numeral page numbers by changing `\thispagestyle{empty}` → `\thispagestyle{plain}` in both environments

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% GATECH-THESIS.CLS (v1.7)
%% Copyright (c) 2002 by Charles S. Wilson. All rights reserved.
%% See licensing information, below.
%%
%% Last Update: V1.8 (2 July 2010) by Mitchel T. Keller
%%
%% Heritage:
%%   UT-THESIS.CLS (v1.8) 
%%     -- by Francois Pitt (1999 Dec 10)
%%     -- as modified by Aichen Low, 2000 Jan 14
%%   GTthesis.sty
%%     -- as adapated from suthesis.sty by Ahmed Gheith
%%     -- and modified by Joonwon Lee, Eilin Tien Lin, Wei Lui
%%     -- and as modified by Kalyan Perumalla, 1999 Nov 18
%%   gt-thesissty.sty
%%     -- by Aichen Low, 2000 Jan 17
%%
%% All of these sources were combined to produce a single, unified
%% class file for Georgia Tech PhD Theses.
%%
%% This file was heavily and amateurishly edited by:
%%
%% Forrest Montgomery Jul 17, 2017
%%
%% if there are significant LaTeX syntax errors I apologize. I gave this my best shot.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\gtthesisversion}{1.9.2}% current version number
\newcommand{\gtthesisupdated}{2022/08/01}% date of last change(s)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License
%% as published by the Free Software Foundation; either version 2
%% of the License, or (at your option) any later version.
%%
%% This program is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%% GNU General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
%%
%% See the COPYING file for license information.
%%
%% Note that the files contained within ThesisProposal.tar.gz have 
%% their own licence.
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%%  REVISION HISTORY:
%%  v1.9.2: 2018-Jul-08 Gerald Eaglin - geaglin2012@gmail.com
%%      * Make chapter headings on a single line in accordance with Guidelines for the
%%	      Preparation and Submission of Theses at ULL (2017)
%%	v1.9: 2018-Apr-04 Daniel M. Newman - danielnewman09@gmail.com
%%		* Updated this template to be compatible with currrent (Fall 2017)
%%		  Guidelines for the Preparation and Submission of Theses at ULL
%%		  http://www.ucs.louisiana.edu/~dpd0909/4/Guidelines4.html#p=1
%%  v1.8: 2010-Jul-02 Mitchel T. Keller
%%      * Change font used in Table of Contents for volumes (parts).
%%      * Add support for abstract page meeting UMI requirements.
%%      * Fix bug that prevented hyperref and overpic packages from
%%        working together properly.
%%  v1.7: 2006-Jan-24  Mitchel T. Keller
%%      * Remove double spacing of thesis title as per July 2005
%%        manual.
%%      * Reduce font size of thesis title, chapter titles, author,
%%        and volume titles.
%%      * Update approval page to comply with electronic submission
%%        requirements (no signature line, all committee members'
%%        affiliations listed, approval date printed on page).
%%  v1.6: 2003-Apr-14  Charles S. Wilson
%%      * caption labels: OGS requires (e.g.) 'Figure 2:' to be in
%%        same font as rest of caption (bold ok, changing font not ok)
%%      * make vita double-spaced
%%      * fixed a bug in Signature page when no Committee Chair.  Thanks
%%        Arnaud Cottet for reporting it.
%%      * Changed one-and-a-half spacing to better match the description
%%        in The LaTeX Companion (use 1.25, not 1.33).
%%  v1.5: 2002-Aug-17  Charles S. Wilson
%%      * COMPLIANCE: new documentation
%%      * caption labels: make them prettier
%%      * Change gatech-thesis-gloss.sty to handle real glossaries;
%%      * NEW: gatech-thesis-losa.sty now handles the List of Symbols
%%  v1.4: 2002-Aug-03  Charles S. Wilson
%%      * Better handling of equation, table, and figure numbering
%%        (added David Carlisle's \@removefromreset macro, and use
%%        that instead of the previous kludge.)
%%      * Corrected problem with two-sided printing: the even-numbered
%%        (left hand) page between the end of \preliminary and the
%%        beginning of the first chapter was not printed.  This really
%%        messed up duplex printers.  FIXED.
%%      * Corrected problem when vita (or whatever the last section
%%        before \end{postliminary}) was \included instead of \inputted.
%%      * Signature page no longer prints empty lines for non-existent 
%%        committee members.  Also, uses two columns if more than 4
%%        members, per the Graduate Office Guidelines.  AND we no longer
%%        print its page number
%%      * Now uses (requires) the calc package, which is part of the
%%        standard latex installation.
%%      * Automatically center the dedication (but see the new functions
%%        \dedicationtop and \dedicationbottom
%%      * Correctly doublespace the title on both titlepage and signaturepage
%%      * page numbering defaults to a centered footer, as per the new
%%        Graduate Office guidelines
%%      * Added proper handling for multiple volumes in a single thesis
%%      * Added support for the add-on styles ``gatech-thesis-gloss.sty''
%%        and ``gatech-thesis-index.sty''.
%%  v1.3: 2002-Jan-13  Charles S. Wilson
%%      * Renamed to gatech-thesis at request of the CTAN folks.
%%  v1.2: 2001-May-01  Charles S. Wilson
%%      * Minor tweaks to conform to latest GSO requirements
%%  v1.1: 2001-Apr-29  Charles S. Wilson
%%      * Fixup to work nicely with pdflatex and hyperref
%%  v1.0: 2001-Jan-24  Charles S. Wilson
%%      * Initial release: merged UT-THESIS.STY with GTthesis.sty
%%        and gt-thesissty.sty.
%%
%%  KNOWN BUGS:
%%
%%   - FIXED: (sortof) [On ``dedication'' and ``acknowledgements''
%%     causing an error when they both appear on the same page.]
%%     GT style doesn't allow these to appear on the same page,
%%     so \begin{dedication}...\end{dedication} will ALWAYS
%%     appear on its own page.  Ditto acknowledgements.
%%
%%   - I didn't fix this; GATECH-THESIS.CLS has inherited this bug
%%     from UT-THESIS.CLS: [On missing page headers for float pages.]
%%     ``teTex'' under Linux fails in precisely the same way as does
%%     ``MikTeX'', so there's something clearly wrong somewhere, but
%%     I don't know where.  It only fails on odd-numbered pages (if
%%     you remove enough text so that the page floats back to an
%%     even-numbered page, the page header is correct)!
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% The following notice and changelog is included to satisfy the 
%% distribution requirements explained below, but much of it no
%% longer applies.  GATECH-THESIS.CLS has been changed in major ways
%% from UT-THESIS.CLS...
%%
%% OLD:
%% OLD:  This file is distributed in the hope that it will be useful but
%% OLD:  without any warranty (without even the implied warranty of
%% OLD:  fitness for a particular purpose).  For a description of this
%% OLD:  file's purpose, and instructions on its use, see below.
%% OLD:  
%% OLD:  Feel free to copy and redistribute this file, as long as this
%% OLD:  copyright notice remains intact.  You may also modify the file
%% OLD:  to suit your particular needs, as long as you indicate your
%% OLD:  changes below (and inform the original author of your changes:
%% OLD:  he's always curious to know what people think of his work).
%% OLD:  
%% OLD:  Send all bugs, questions, comments, suggestions, etc. to the
%% OLD:  author, at <fpitt@cs.utoronto.ca>.
%% OLD:  
%% OLD:  KNOWN BUGS: (reported by Robert Bernecky)
%% OLD:  
%% OLD:   - [On missing page headers for float pages.]
%% OLD:     ``teTex'' under Linux fails in precisely the same way as does
%% OLD:     ``MikTeX'', so there's something clearly wrong somewhere, but
%% OLD:     I don't know where.  It only fails on odd-numbered pages (if
%% OLD:     you remove enough text so that the page floats back to an
%% OLD:     even-numbered page, the page header is correct)!
%% OLD:   - [On ``dedication'' and ``acknowledgements'' causing an error when
%% OLD:      they both appear on the same page.]
%% OLD:     ``teTeX'' and ``MikTeX'' both fail the same way on this one, with
%% OLD:     ``LaTeX error: Something's wrong--perhaps a missing \item.
%% OLD:     Adding a \newpage between the two environments ``fixes'' the
%% OLD:     problem.  Unsure what causes this, but it could be a bug
%% OLD:     common to all x86 platforms...
%% OLD:  
%% OLD:  REVISION HISTORY:
%% OLD:  
%% OLD:  v1.8: 1999/12/10 (Francois Pitt)
%% OLD:      - Fixed circular definition problem with \currenttextsize
%% OLD:        that caused TeX to run out of input stack memory.
%% OLD:  v1.7: 1999/06/02,1999/05/20,1999/05/13 (Francois Pitt)
%% OLD:      - Minor change to the format of the date printed on every
%% OLD:        page with the ``draft'' option.
%% OLD:      - Minor cosmetic change to the word ``DRAFT'' printed on the
%% OLD:        corners of every page with the ``draft'' option.
%% OLD:      - Made ``draft'' mode doublespaced by default (it just makes
%% OLD:        more sense for actual drafts; suggested by Eric Joanis).
%% OLD:      - Changed \currenttextsize from a ``\newcommand'' to a ``\let''.
%% OLD:      - Added ``known bugs'' above.
%% OLD:  v1.6: 1999/03/06 (Francois Pitt)
%% OLD:      - Minor change: replaced ``\ifx\empty#1\else...\fi'' with
%% OLD:        ``\ifx\empty#1\empty\else...\fi'' (the former works only
%% OLD:        by accident while the latter is logically correct).
%% OLD:  v1.5: 1999/02/17 (Francois Pitt)
%% OLD:      - Fixed missing page numbers and headers by removing
%% OLD:        redefinition of \cleardoublepage (reported by Robert
%% OLD:        Bernecky 1999/02/04 and Nedialko Nedialkov 1999/02/12).
%% OLD:      - Added \clearemptydoublepage and \clearplaindoublepage
%% OLD:        commands.
%% OLD:      - Removed redefinitions of \tableofcontents, \listoftables,
%% OLD:        and \listoffigures because they already call \clearpage
%% OLD:        or \cleardoublepage by default.
%% OLD:      - Removed ``\setcounter{tocdepth}{2}'' from the page layout
%% OLD:        section (moved to ``ut-thesis.tex'' where it belongs).
%% OLD:      - Added \ignore command to comment out parts of a file.
%% OLD:      - Put version macros at the top of the file.
%% OLD:      - Changed order of revision comments.
%% OLD:  v1.4: 1998/11/05 (Francois Pitt)
%% OLD:      - Fixed ``abstract'' environment so that it is really put on a
%% OLD:        separate page, and changed ``\newpage\endgroup'' at the end
%% OLD:        to ``\par\endgroup\newpage'', which is more logical.
%% OLD:      - Changed ``acknowledgements'' environment so that it is *not*
%% OLD:        put on a separate page, allowing users to add other text
%% OLD:        on that page (e.g., ``dedication'' described next).
%% OLD:      - Added ``dedication'' environment based on ``acknowledgements''
%% OLD:        (suggested by Robert Bernecky 98/11/04).
%% OLD:      - Changed page layout so that it is defined in terms of the
%% OLD:        physical page size instead of being hard-coded for letter
%% OLD:        paper (8.5" x 11").
%% OLD:  v1.3: 1998/11/01 (Francois Pitt)
%% OLD:      - Fixed ``thebibliography'' so page headers are generated in
%% OLD:        the same style as for the rest of the thesis.
%% OLD:      - Swapped \endgroup and \newpage in definition of ``abstract''
%% OLD:        and ``acknowledgements'' environments, to fix problem with
%% OLD:        adjusted line spacing in ``abstract''.
%% OLD:      - Renamed ``\currentsize'' to ``\currenttextsize''.
%% OLD:      - Added \cleardoublepage at the end of preliminary sections,
%% OLD:        so that page 1 of main text is on right-hand side.
%% OLD:  v1.2: 1998/10/20 (Francois Pitt)
%% OLD:      - Changed ``spacenotes'' option to ``spacednotes'' to have more
%% OLD:        consistently named options.
%% OLD:      - Fixed spacing between main text and footnotes.
%% OLD:      - Fixed ``singlespaced'' environment, which didn't seem to
%% OLD:        work at all (reported by Nedialko Nedialkov 98/10/12):
%% OLD:        Actually, created a ``newspacing'' environment, which takes
%% OLD:        a parameter, and based ``singlespaced'', ``oneandahalfspaced'',
%% OLD:        and ``doublespaced'' environments on ``newspacing''.
%% OLD:  v1.1: 1998/10/01 (Francois Pitt)
%% OLD:      - Fixed bug that caused footnotes to make following tables
%% OLD:        single-spaced (reported by Philip Edmonds 98/09/30).
%% OLD:      - Made spacing of marginal notes and footnotes the same.
%% OLD:      - Added option to control line spacing of notes.
%% OLD:      - Added options to control the size of margins.
%% OLD:      - Changed names of temporary macros used in redefinitions
%% OLD:        to avoid conflicts with existing names.
%% OLD:  v1.0: 1998/09/29 (Francois Pitt)
%% OLD:      - Initial version.
%% OLD:  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%        IDENTIFICATION        %%%%%%%%%%%%

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{gatech-thesis}
        [\gtthesisupdated\space\gtthesisversion\space(Mitchel T. Keller)]%
\RequirePackage{calc}% part of LaTeX tools bundle   
%\RequirePackage{lastpage}

\def\gtthesis@checkVersion#1{\edef\reserved@a{#1}%
  \ifx \gatechthesis@version \reserved@a
    \expandafter\@gobble
  \else
    \expandafter\@firstofone
  \fi}
\xdef\gatechthesis@version{\gtthesisversion}

%%%%%%%%%%%%         INITIAL CODE         %%%%%%%%%%%%

%% To comment out parts of a file.
%
\newcommand{\ignore}[1]{}
\newcommand{\comment}[1]{}

%% Switch for testing draft mode (toggled by ``draft'' option).
%
\newif\if@draft
\@draftfalse % initially false by default

%% Switch for testing current page style.
%
\newif\if@tcpage
 % no default value (set by \pagestyle)
 % indicates that page numbers are in the upper corners

%% Switch for testing line spacing of notes.
%
\newif\if@singlespacednotes
\@singlespacednotestrue % initially true by default

%% Switch for testing the hyperref option
%
\newif\if@hyperref
\@hyperreffalse % initially false by default

%% Macro for testing the size of margins.
%
\newcommand{\@marginsize}{}

%% Because of the draft option, and to allow users to override
%% defaults, we don't want to be passing conflicting options back to
%% the report class, so we define our own temporary toggles holding
%% the most recent setting for each of four basic options: point size,
%% number of page sides, whether new chapters open on right-hand pages
%% or on any page, and line spacing.  These toggles will be set from
%% the corresponding options below.
%
\newcommand{\@thesisptsz}{}
\newcommand{\@thesisside}{}
\newcommand{\@thesisopen}{}
\newcommand{\@thesislnsp}{}


%%%%%%%%%%%%      OPTION DECLARATION      %%%%%%%%%%%%

%% ``draft'' option: change default document settings.
%
\DeclareOption{draft}{\@drafttrue
   \typeout{Gatech-Thesis Class Option: ``draft''}
   \ExecuteOptions{10pt,twoside,openany,doublespaced,normalmargins}
   \PassOptionsToClass{draft}{report}
   %% Macros for printing "DRAFT" at the corners of a page.
   \newcommand{\tlDRAFT}%
     {\raisebox{ 3ex}[0pt][0pt]{\llap{\sffamily\scriptsize DRAFT\ \ }}}
   \newcommand{\trDRAFT}%
     {\raisebox{ 3ex}[0pt][0pt]{\rlap{\sffamily\scriptsize \ \ DRAFT}}}
   \newcommand{\blDRAFT}%
     {\raisebox{-3ex}[0pt][0pt]{\llap{\sffamily\scriptsize DRAFT\ \ }}}
   \newcommand{\brDRAFT}%
     {\raisebox{-3ex}[0pt][0pt]{\rlap{\sffamily\scriptsize \ \ DRAFT}}}
}%DeclareOption{draft}

%% ``spacednotes'' option: make notes share the line spacing of the rest
%% of the document.
%
\DeclareOption{spacednotes}{\@singlespacednotesfalse}

%% Margin options: change the size of margins.
%% choose normalmargins option for Georgia Tech thesis format
%
\DeclareOption{narrowmargins}{\renewcommand{\@marginsize}{0}}
\DeclareOption{normalmargins}{\renewcommand{\@marginsize}{1}}
\DeclareOption{widemargins}{\renewcommand{\@marginsize}{2}}
\DeclareOption{extrawidemargins}{\renewcommand{\@marginsize}{3}}
\DeclareOption{oldmargins}{\renewcommand{\@marginsize}{4}}
\DeclareOption{ullmargins}{\renewcommand{\@marginsize}{5}}

%% Point Size options: change current setting.
%
\DeclareOption{10pt}{\renewcommand{\@thesisptsz}{10pt}}
\DeclareOption{11pt}{\renewcommand{\@thesisptsz}{11pt}}
\DeclareOption{12pt}{\renewcommand{\@thesisptsz}{12pt}}

%% Number of Page Sides options: change current setting.
%
\DeclareOption{twoside}{\renewcommand{\@thesisside}{twoside}}
\DeclareOption{oneside}{\renewcommand{\@thesisside}{oneside}}

%% New Chapter Openings options: change current setting.
%
\DeclareOption{openany}{\renewcommand{\@thesisopen}{openany}}
\DeclareOption{openright}{\renewcommand{\@thesisopen}{openright}}

%% Line Spacing options: change current setting.
%
\DeclareOption{singlespaced}{\renewcommand{\@thesislnsp}{1}}
\DeclareOption{oneandahalfspaced}{\renewcommand{\@thesislnsp}{1.25}}
\DeclareOption{doublespaced}{\renewcommand{\@thesislnsp}{1.66}}

%% STUPID HACK for hyperref, \@chapter, and \MakeUppercase
%
\newcommand{\Makeuppercase}[1]{\MakeUppercase{#1}}
\DeclareOption{hyperref}{%
  \@hyperreftrue
%  \renewcommand{\Makeuppercase}[1]{%
%    \ifHy@pdfstring#1\else\MakeUppercase{#1}\fi}
}

%% All other options are passed to the base class directly.
%
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{report}}


%%%%%%%%%%%%       OPTION EXECUTION       %%%%%%%%%%%%

%% Default settings.
%
\ExecuteOptions{11pt,letterpaper,oneside,%
openright,doublespaced,normalmargins,final}
%
%% Process options.
%
\ProcessOptions


%%%%%%%%%%%%       PACKAGE  LOADING       %%%%%%%%%%%%

%% Load base class using current setting for basic options.
%
\LoadClass[\@thesisptsz,\@thesisside,\@thesisopen]{report}


%% From lastpage package. Used to generate abstract.
%% Lastpage is written by Jeff Goldberg (J.Goldberg@Cranfield.ac.uk)
%% It is relased under the GPL (version 2)

\def\lastpage@putlabel{\addtocounter{page}{-1}%
   \immediate\write\@auxout{\string
   \newlabel{LastPage}{{}{\thepage}{}{}{}}}%
   \addtocounter{page}{1}}


%%%%%%%%%%%%          MAIN  CODE          %%%%%%%%%%%%

\if@hyperref
\else
  \newcommand{\phantomsection}{}% helps with hyperref.  \phantomsection
%                                 is provided by pdflatex, but not latex.
  \newcommand{\texorpdfstring}[2]{#1}%
  \def\pdfbookmark[#1]#2#3{}%
\fi

%%%%%%    Line Spacing
%
%% \linespacing is used to define the default line spacing. 
%% for the entire document. If the argument is less than 
%% 1.25 (for 1.5-spaced) a warning message is displayed
%% when not in draft mode.
%%
%% Don't use this command for temporary, localized changes.
%% Instead, use the ``spacing environments'':
%%    \begin{singlespace}      ...\end{singlespaced}
%%    \begin{oneandahalfspaced}...\end{oneandahalfspaced}
%%    \begin{doublespaed}      ...\end{doublespaced}
%%    \begin{longquote}        ...\end{longquote}
%%    \begin{longquotation}    ...\end{longquotation}
%%    \begin{newspacing}{x.xx} ...\end{newspacing}
%
\newcommand{\linespacing}[1]{%
  \gdef\@spacing{#1}
  \newlinestretch{#1}\if@draft\else\ifdim #1pt < 1.25pt\typeout
   {Gatech-Thesis Class Warning: line spacing less than 1 1/2}\fi\fi
}
%
%% \spacing is a clone of \linespacing, retained for backwards
%% compatibility with GTthesis.sty
%
\newcommand{\spacing}[1]{%
  \gdef\@spacing{#1}
  \newlinestretch{#1}\if@draft\else\ifdim #1pt < 1.25pt\typeout
  {Gatech-Thesis Class Warning: line spacing less than 1 1/2}\fi\fi
}
\def\@spacing{1.66}

%
%% ``longquote'' and ``longquotation'' produce single-spaced quotes, while
%% ``newspacing'' encloses paragraphs with a different line spacing,
%% such as ``singlespaced'', ``oneandahalfspaced'', or ``doublespaced''.
%
\newenvironment{longquote}%
  {\begin{quote}\newlinestretch{1}}{\end{quote}}
\newenvironment{longquotation}%
  {\begin{quotation}\newlinestretch{1}}{\end{quotation}}
\newenvironment{singlespaced}%
  {\begin{newspacing}{1}}{\end{newspacing}}
\newenvironment{oneandahalfspaced}%
  {\begin{newspacing}{1.25}}{\end{newspacing}}
\newenvironment{doublespaced}%
  {\begin{newspacing}{1.66}}{\end{newspacing}}
\newenvironment{newspacing}[1]%
  {\par\begingroup\newlinestretch{#1}}%
  {\par\vskip\parskip\vskip\baselineskip\endgroup
   \vskip-\parskip\vskip-\baselineskip}


%
%% To change the actual line spacing.
%
\newcommand{\newlinestretch}[1]%
  {\renewcommand{\baselinestretch}{#1}\currenttextsize}

%
%% To keep track of the current text size.
%
\let\currenttextsize=\normalsize
%
%% Redefine size-changing commands to update \currenttextsize.
%
\let\tmp@tiny=\tiny
\renewcommand{\tiny}%
  {\let\currenttextsize=\tmp@tiny\tmp@tiny}
\let\tmp@scriptsize=\scriptsize
\renewcommand{\scriptsize}%
  {\let\currenttextsize=\tmp@scriptsize\tmp@scriptsize}
\let\tmp@footnotesize=\footnotesize
\renewcommand{\footnotesize}%
  {\let\currenttextsize=\tmp@footnotesize\tmp@footnotesize}
\let\tmp@small=\small
\renewcommand{\small}%
  {\let\currenttextsize=\tmp@small\tmp@small}
\let\tmp@normalsize=\normalsize
\renewcommand{\normalsize}%
  {\let\currenttextsize=\tmp@normalsize\tmp@normalsize}
\let\tmp@large=\large
\renewcommand{\large}%
  {\let\currenttextsize=\tmp@large\tmp@large}
\let\tmp@Large=\Large
\renewcommand{\Large}%
  {\let\currenttextsize=\tmp@Large\tmp@Large}
\let\tmp@LARGE=\LARGE
\renewcommand{\LARGE}%
  {\let\currenttextsize=\tmp@LARGE\tmp@LARGE}
\let\tmp@huge=\huge
\renewcommand{\huge}%
  {\let\currenttextsize=\tmp@huge\tmp@huge}
\let\tmp@Huge=\Huge
\renewcommand{\Huge}%
  {\let\currenttextsize=\tmp@Huge\tmp@Huge}
%
%% Make notes single-spaced if ``spacednotes'' option was not given.
%% Note that this does _not_ change the spacing of figures or tables.
%
\if@singlespacednotes
%% Make footnotes single-spaced.
\let\tmp@@footnotetext=\@footnotetext
\renewcommand{\@footnotetext}[1]%
  {{\newlinestretch{1}\tmp@@footnotetext{#1}}}
%% Make footnotes inside a minipage single-spaced.
\let\tmp@@mpfootnotetext=\@mpfootnotetext
\renewcommand{\@mpfootnotetext}[1]%
  {{\newlinestretch{1}\tmp@@mpfootnotetext{#1}}}
%% Make marginal notes single-spaced.
\let\tmp@@marginparreset=\@marginparreset
\renewcommand{\@marginparreset}%
  {\newlinestretch{1}\tmp@@marginparreset}
\fi%@singlespacednotes
% 
%%%%%%    New formatting environments and commands.
%
%% \begin{preliminary} sets the pagestyle and pagenumbering 
%% (roman numeral format ) for the preliminary sections; 
%% It also calls \beforepreface to create the title page
%% and signature page if indicated by \titlepagetrue and/or
%% \signaturepageture.
%%
%% \end{preliminary} resets the pagenumbering. To start page 
%% numbering in arabic format, use \pagestyle{plain} and 
%% \pagenumbering{arabic} after the preliminary environment block
%
\newenvironment{preliminary}%
  {  
    \newlinestretch{1.0}%
    \pagenumbering{roman}%
    \pagestyle{\front@pagestyle}%
    \iftitlepage%
      \maketitle%
    \fi%
    \ifmultivolume%
      \part{}%
    \fi%
    \ifsignaturepage%
      \makesignature%
    \fi%
    \newlinestretch{\@spacing}%
  }%
  {%
    \if@draft%
    \else%
      \if@twoside%
        \if@openright%
          \cleardoublepage%
        \fi%
      \fi%
    \fi%
    \newpage%
    \pagenumbering{arabic}%
    \pagestyle{\body@pagestyle}%
    \newlinestretch{\@spacing}%
  }%

%%%%%%    Front Matter Parameters
%
%% The following commands set the respective field values so we
%% can generate the title page, signature page, and abstract
%% page automatically
%

\renewcommand{\author}[1]%
  {\ifx\empty#1\empty\else\gdef\@author{#1}\fi}

\newcommand{\lastnamefirstname}[1]%
  {\ifx\empty#1\empty\else\gdef\@lastnamefirstname{#1}\fi}

\newcommand{\undergrad}[1]%
{\ifx\empty#1\empty\else\gdef\@undergrad{#1}\fi}

\newcommand{\wordsinabstract}[1]%
{\ifx\empty#1\empty\else\gdef\@wordsinabstract{#1}\fi}

\newcommand{\undergraduniversity}[1]%
{\ifx\empty#1\empty\else\gdef\@undergraduniversity{#1}\fi}

\newcommand{\totalpagesinthesis}[1]%
{\ifx\empty#1\empty\else\gdef\@totalpagesinthesis{#1}\fi}

\newcommand{\undergradyear}[1]%
{\ifx\empty#1\empty\else\gdef\@undergradyear{#1}\fi}

\renewcommand{\title}[1]%
  {\ifx\empty#1\empty\else\gdef\@title{#1}\fi}

\newcommand{\degree}[1]%
  {\ifx\empty#1\empty\else\gdef\@degree{#1}\fi}
  
%%%%%%%%%%%%%%%%%%%%%%%%%
% Define whether this is a thesis, dissertation, or anything else
\newcommand{\worktype}[1]%
  {\ifx\empty#1\empty\else\gdef\@worktype{#1}\fi}

%
%% Is this a thesis, or a thesis proposal ?
%
\newif\ifthesisproposal
\thesisproposalfalse % default to thesis, not thesis proposal

%
%% Is this a thesis or a dissertation?
%
\newif\ifdissertation
\dissertationfalse % default to thesis

%
%% Do we list the major in the ``Partial Fulfillment'' block or the department?
%
\newif\iflistmajor
\listmajorfalse % default to listing the department

\newcommand{\major}[1]%
   {\ifx\empty#1\empty\else\gdef\@major{#1}\fi}

%
%% \department and \dept are synonymous
%
\newcommand{\department}[1]%
  {\ifx\empty#1\empty\else\gdef\@department{#1}\gdef\@dept{#1}\fi}
\newcommand{\dept}[1]%
  {\ifx\empty#1\empty\else\gdef\@department{#1}\gdef\@dept{#1}\fi}
%
%% date stuff
%% \gradyear and \copyrightyear are synonymmous
%
\newcommand{\gradyear}[1]%
  {\ifx\empty#1\empty\else\gdef\@gradyear{#1}\gdef\@copyrightyear{#1}\fi}
\newcommand{\copyrightyear}[1]%
  {\ifx\empty#1\empty\else\gdef\@gradyear{#1}\gdef\@copyrightyear{#1}\fi}
\newcommand{\submitdate}[1]%
  {\ifx\empty#1\empty\else\gdef\@submitdate{#1}\fi}
\newcommand{\approveddate}[1]%
  {\ifx\empty#1\empty\else\gdef\@approveddate{#1}\fi}
%
%% use \principaladviser{} or \principaladvisor{}.  Choice also
%% sets the default spelling of ``advisor/adviser''.
%
\def\advis@r{Advisor} % default spelling

% Define \principaladvisor{} to take two optional arguments after the
% name. Thus, the usage is 
%    \principaladvisor{Advisor Name}[Advisor Unit][Advisor Institution]
% Advisor Unit defaults to \@department and Advisor Institution
% defaults to Georgia Institute of Technology.
% Dean of the Graduate School — store in \@deanreader (3-tuple)
\newcommand{\deanofgradschool}[1]{%
  \@ifnextchar[{\deanofgradschool@i{#1}}{\deanofgradschool@i{#1}[\@department]}%]
}
\def\deanofgradschool@i#1[#2]{%
  \@ifnextchar[{\deanofgradschool@ii{#1}[#2]}{\deanofgradschool@ii{#1}[#2][]}%]
}
\def\deanofgradschool@ii#1[#2][#3]{%
  \def\@deanreader{}%
  \rightappenditem#1\to\@deanreader%   Name
  \rightappenditem#2\to\@deanreader%   Unit/Role (e.g., Dean of the Graduate School)
  \rightappenditem#3\to\@deanreader%   Institution (optional)
}

\def\principaladvisor@i#1[#2]{%
  \@ifnextchar[{\principaladvisor@ii{#1}[#2]}{\principaladvisor@ii{#1}[#2][]}%]
}
\def\principaladvisor@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\def\@advisorforabstract{#1}%
    \rightappenditem#1\to\@principaladvisor%
    \rightappenditem#2\to\@principaladvisor%
    \rightappenditem#3\to\@principaladvisor%
    \fi
}           

% Define \principaladviser{} to take two optional arguments after the
% name. Thus, the usage is 
%    \principaladviser{Adviser Name}[Adviser Unit][Adviser Institution]
% Adviser Unit defaults to \@department and Adviser Institution
% defaults to Georgia Institute of Technology.
\newcommand{\principaladviser}[1]{%
  \@ifnextchar[{\principaladviser@i{#1}}{\principaladviser@i{#1}[\@department]}%]
}
\def\principaladviser@i#1[#2]{%
  \@ifnextchar[{\principaladviser@ii{#1}[#2]}{\principaladviser@ii{#1}[#2][]}%]
}
\def\principaladviser@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\def\@advisorforabstract{#1}%
    \rightappenditem#1\to\@principaladvisor%
    \rightappenditem#2\to\@principaladvisor%
    \rightappenditem#3\to\@principaladvisor%
    \gdef\advis@r{Adviser}%
    \fi
}          

%
%% Committee Chair
%
% Define \committeechair{} to take two optional arguments after the
% name. Thus, the usage is 
%    \committeechair{Name}[Unit][Institution]
% Unit defaults to \@department and Institution defaults to Georgia
% Institute of Technology.
\newcommand{\committeechair}[1]{%
  \@ifnextchar[{\committeechair@i{#1}}{\committeechair@i{#1}[\@department]}%]
}
\def\committeechair@i#1[#2]{%
  \@ifnextchar[{\committeechair@ii{#1}[#2]}{\committeechair@ii{#1}[#2][]}%]
}
\def\committeechair@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\def\@chairforabstract{#1}
\ifx\empty#1\empty\else\rightappenditem#1\to\@committeechair%
    \rightappenditem#2\to\@committeechair%
    \rightappenditem#3\to\@committeechair%
    \fi
}          

%
%% readers
%
% Define \{first|second|third|fourth|fifth|sixth}reader{} to take two
% optional arguments after the name. Thus, the usage is 
%    \*reader{Reader Name}[Reader Unit][Reader Institution]
% Reader Unit defaults to \@department and Reader Institution
% defaults to Georgia Institute of Technology.
\newcommand{\firstreader}[1]{%
  \@ifnextchar[{\firstreader@i{#1}}{\firstreader@i{#1}[\@department]}%]
}
\def\firstreader@i#1[#2]{%
  \@ifnextchar[{\firstreader@ii{#1}[#2]}{\firstreader@ii{#1}[#2][]}%]
}
\def\firstreader@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\rightappenditem#1\to\@firstreader%
    \rightappenditem#2\to\@firstreader%
    \rightappenditem#3\to\@firstreader%
    \fi
}          

\newcommand{\secondreader}[1]{%
  \@ifnextchar[{\secondreader@i{#1}}{\secondreader@i{#1}[\@department]}%]
}
\def\secondreader@i#1[#2]{%
  \@ifnextchar[{\secondreader@ii{#1}[#2]}{\secondreader@ii{#1}[#2][]}%]
}
\def\secondreader@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\rightappenditem#1\to\@secondreader%
    \rightappenditem#2\to\@secondreader%
    \rightappenditem#3\to\@secondreader%
    \fi
}          

\newcommand{\thirdreader}[1]{%
  \@ifnextchar[{\thirdreader@i{#1}}{\thirdreader@i{#1}[\@department]}%]
}
\def\thirdreader@i#1[#2]{%
  \@ifnextchar[{\thirdreader@ii{#1}[#2]}{\thirdreader@ii{#1}[#2][]}%]
}
\def\thirdreader@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\rightappenditem#1\to\@thirdreader%
    \rightappenditem#2\to\@thirdreader%
    \rightappenditem#3\to\@thirdreader%
    \fi
}          

\newcommand{\fourthreader}[1]{%
  \@ifnextchar[{\fourthreader@i{#1}}{\fourthreader@i{#1}[\@department]}%]
}
\def\fourthreader@i#1[#2]{%
  \@ifnextchar[{\fourthreader@ii{#1}[#2]}{\fourthreader@ii{#1}[#2][]}%]
}
\def\fourthreader@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\rightappenditem#1\to\@fourthreader%
    \rightappenditem#2\to\@fourthreader%
    \rightappenditem#3\to\@fourthreader%
    \fi
}          

\newcommand{\fifthreader}[1]{%
  \@ifnextchar[{\fifthreader@i{#1}}{\fifthreader@i{#1}[\@department]}%]
}
\def\fifthreader@i#1[#2]{%
  \@ifnextchar[{\fifthreader@ii{#1}[#2]}{\fifthreader@ii{#1}[#2][]}%]
}
\def\fifthreader@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\rightappenditem#1\to\@fifthreader%
    \rightappenditem#2\to\@fifthreader%
    \rightappenditem#3\to\@fifthreader%
    \fi
}          

\newcommand{\sixthreader}[1]{%
  \@ifnextchar[{\sixthreader@i{#1}}{\sixthreader@i{#1}[\@department]}%]
}
\def\sixthreader@i#1[#2]{%
  \@ifnextchar[{\sixthreader@ii{#1}[#2]}{\sixthreader@ii{#1}[#2][]}%]
}
\def\sixthreader@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\rightappenditem#1\to\@sixthreader%
    \rightappenditem#2\to\@sixthreader%
    \rightappenditem#3\to\@sixthreader%
    \fi
}          

\newcommand{\seventhreader}[1]{%
  \@ifnextchar[{\seventhreader@i{#1}}{\seventhreader@i{#1}[\@department]}%]
}
\def\seventhreader@i#1[#2]{%
  \@ifnextchar[{\seventhreader@ii{#1}[#2]}{\seventhreader@ii{#1}[#2][]}%]
}
\def\seventhreader@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\rightappenditem#1\to\@seventhreader%
    \rightappenditem#2\to\@seventhreader%
    \rightappenditem#3\to\@seventhreader%
    \fi
}

\newcommand{\eighthreader}[1]{%
  \@ifnextchar[{\eighthreader@i{#1}}{\eighthreader@i{#1}[\@department]}%]
}
\def\eighthreader@i#1[#2]{%
  \@ifnextchar[{\eighthreader@ii{#1}[#2]}{\eighthreader@ii{#1}[#2][]}%]
}
\def\eighthreader@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\rightappenditem#1\to\@eighthreader%
    \rightappenditem#2\to\@eighthreader%
    \rightappenditem#3\to\@eighthreader%
    \fi
}

\newcommand{\ninthreader}[1]{%
  \@ifnextchar[{\ninthreader@i{#1}}{\ninthreader@i{#1}[\@department]}%]
}
\def\ninthreader@i#1[#2]{%
  \@ifnextchar[{\ninthreader@ii{#1}[#2]}{\ninthreader@ii{#1}[#2][]}%]
}
\def\ninthreader@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\rightappenditem#1\to\@ninthreader%
    \rightappenditem#2\to\@ninthreader%
    \rightappenditem#3\to\@ninthreader%
    \fi
}

\newcommand{\tenthreader}[1]{%
  \@ifnextchar[{\tenthreader@i{#1}}{\tenthreader@i{#1}[\@department]}%]
}
\def\tenthreader@i#1[#2]{%
  \@ifnextchar[{\tenthreader@ii{#1}[#2]}{\tenthreader@ii{#1}[#2][]}%]
}
\def\tenthreader@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\rightappenditem#1\to\@tenthreader%
    \rightappenditem#2\to\@tenthreader%
    \rightappenditem#3\to\@tenthreader%
    \fi
}

\newcommand{\eleventhreader}[1]{%
  \@ifnextchar[{\eleventhreader@i{#1}}{\eleventhreader@i{#1}[\@department]}%]
}
\def\eleventhreader@i#1[#2]{%
  \@ifnextchar[{\eleventhreader@ii{#1}[#2]}{\eleventhreader@ii{#1}[#2][]}%]
}
\def\eleventhreader@ii#1[#2][#3]{%
\ifx\empty#1\empty\else\rightappenditem#1\to\@eleventhreader%
    \rightappenditem#2\to\@eleventhreader%
    \rightappenditem#3\to\@eleventhreader%
    \fi
}

% 12th reader
\newcommand{\twelfthreader}[1]{%
  \@ifnextchar[{\twelfthreader@i{#1}}{\twelfthreader@i{#1}[\@department]}%]
}
\def\twelfthreader@i#1[#2]{%
  \@ifnextchar[{\twelfthreader@ii{#1}[#2]}{\twelfthreader@ii{#1}[#2][]}%]
}
\def\twelfthreader@ii#1[#2][#3]{%
  \ifx\empty#1\empty\else
    \rightappenditem#1\to\@twelfthreader%
    \rightappenditem#2\to\@twelfthreader%
    \rightappenditem#3\to\@twelfthreader%
  \fi
}

% 13th reader
\newcommand{\thirteenthreader}[1]{%
  \@ifnextchar[{\thirteenthreader@i{#1}}{\thirteenthreader@i{#1}[\@department]}%]
}
\def\thirteenthreader@i#1[#2]{%
  \@ifnextchar[{\thirteenthreader@ii{#1}[#2]}{\thirteenthreader@ii{#1}[#2][]}%]
}
\def\thirteenthreader@ii#1[#2][#3]{%
  \ifx\empty#1\empty\else
    \rightappenditem#1\to\@thirteenthreader%
    \rightappenditem#2\to\@thirteenthreader%
    \rightappenditem#3\to\@thirteenthreader%
  \fi
}

% 14th reader
\newcommand{\fourteenthreader}[1]{%
  \@ifnextchar[{\fourteenthreader@i{#1}}{\fourteenthreader@i{#1}[\@department]}%]
}
\def\fourteenthreader@i#1[#2]{%
  \@ifnextchar[{\fourteenthreader@ii{#1}[#2]}{\fourteenthreader@ii{#1}[#2][]}%]
}
\def\fourteenthreader@ii#1[#2][#3]{%
  \ifx\empty#1\empty\else
    \rightappenditem#1\to\@fourteenthreader%
    \rightappenditem#2\to\@fourteenthreader%
    \rightappenditem#3\to\@fourteenthreader%
  \fi
}
% 15th reader
\newcommand{\fifteenthreader}[1]{%
  \@ifnextchar[{\fifteenthreader@i{#1}}{\fifteenthreader@i{#1}[\@department]}%]
}
\def\fifteenthreader@i#1[#2]{%
  \@ifnextchar[{\fifteenthreader@ii{#1}[#2]}{\fifteenthreader@ii{#1}[#2][]}%]
}
\def\fifteenthreader@ii#1[#2][#3]{%
  \ifx\empty#1\empty\else
    \rightappenditem#1\to\@fifteenthreader%
    \rightappenditem#2\to\@fifteenthreader%
    \rightappenditem#3\to\@fifteenthreader%
  \fi
}

% 16th reader
\newcommand{\sixteenthreader}[1]{%
  \@ifnextchar[{\sixteenthreader@i{#1}}{\sixteenthreader@i{#1}[\@department]}%]
}
\def\sixteenthreader@i#1[#2]{%
  \@ifnextchar[{\sixteenthreader@ii{#1}[#2]}{\sixteenthreader@ii{#1}[#2][]}%]
}
\def\sixteenthreader@ii#1[#2][#3]{%
  \ifx\empty#1\empty\else
    \rightappenditem#1\to\@sixteenthreader%
    \rightappenditem#2\to\@sixteenthreader%
    \rightappenditem#3\to\@sixteenthreader%
  \fi
}

%
%% bibliography databases
%
\newcommand{\bibfiles}[1]%
  {\ifx\empty#1\empty\else\gdef\@bibfiles{#1}\fi}

%
%% default values of private functions
%
\def\@title{}
\def\@author{}
\def\@bibfiles{}
\def\@principaladvisor{}
\def\@committeechair{}
\def\@firstreader{}
\def\@secondreader{}
\def\@thirdreader{}
\def\@fourthreader{}
\def\@fifthreader{}
\def\@sixthreader{}
\def\@seventhreader{}
\def\@eighthreader{}
\def\@ninthreader{}
\def\@tenthreader{}
\def\@eleventhreader{}
\def\@twelfthreader{}
\def\@thirteenthreader{}
\def\@fourteenthreader{}
\def\@fifthteenthreader{}
\def\@sixteenthreader{}
\def\@deanreader{}
\def\@submitdate{\ifcase\the\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space \number\the\year}
\def\@copyrightyear{\number\the\year}
\def\@bibfiles{}

%% Switch for printing copyright notice on titlepage
%
\newif\ifcopyright
\copyrightfalse % initially false by default

%% Switch for generating a title page
%
\newif\iftitlepage
\titlepagetrue % initially true by default

%% Switch for generating a signature page
%
\newif\ifsignaturepage
\signaturepagetrue % initially true by default

%% Switch for generating a list of figures
%
\newif\iffigurespage
\figurespagetrue % initially true by default

%% Switch for generating a list of tables
%
\newif\iftablespage
\tablespagetrue % initially true by default

%% Switch for generating a table of contents
%
\newif\ifcontentspage
\contentspagetrue % initially true by default

%% Switch for generating a bibliography
%
\newif\ifbibpage
\bibpagetrue % initially true by default

%% Switch to indicate whether chapters are \input{}'ed or
%% \include{}'ed.  Not currently used.
%
\newif\ifusinginclude
\usingincludefalse % initially false by default -- document uses \input{}

%% Switch for relaxing the strict margin requirements 
%% on the title page and signature page.  Default is to
%% rigidly adhere to the standard (but that's ugly)
%
\newif\ifstrictmargins
\strictmarginstrue % initially true by default

%% Switch for printing DEDICATION across the top of the dedication page
%
\newif\ifdedicationheading
\dedicationheadingfalse % initially false by default

%% Switch for indicating that the thesis has multiple volumes
%
\newif\ifmultivolume
\multivolumefalse % initially false by default

%%%%%%    Front Matter Commands and Environments
%%
%% \beforepreface
%%   --- create title, signature page
%%   --- redefined the \maketitle command here, but
%%       don't call it directly.  Use \beforepreface.
%%
%%   \begin{dedication}...\end{dedication}
%%   \begin{preface}...\end{preface}
%%   \begin{acknowledgements}...\end{acknowlegments}
%%   \prefacesection{other-title}
%%     --- followed by section text
%%   \contents
%%     --- prints table of contents, figures, and tables
%%   \begin{abstract}...\end{abstract}  or use
%%   \begin{summary}...\end{summary}
%% \afterpreface

\newcommand{\title@top}{%
% make sure that linestretch is already set to 1, and all 
% grouping/sectioning commands have already been begun.
  \ifstrictmargins
    \ifnum \@marginsize = 4 % oldmargins
      \vspace*{50\p@}%
    \fi
    \begin{center}%
    \vspace*{4\baselineskip}
        \expandafter{\@title}\\%%%% TITLE FONT SIZE!!!!
    \end{center}%
  \else%
    \begin{center}
%     \vspace*{\stretch{1}}
      \vspace*{1in}
        \expandafter{\@title}%%%%% TITLE FONT SIZE AGAIN
    \end{center}%
  \fi%
}

\newcommand{\title@text}{
  \begin{center}
    \ifthesisproposal
       A Thesis Proposal\\
       Presented to\\
       The Academic Faculty\\
    \else
       %A \ifdissertation Dissertation\else Thesis\fi\\
       
       % MATH: Changed the spacing in here to match
       % Grad School titlepage
       A \@worktype \ 
       Presented to the
       Graduate Faculty\\
       in Partial Fulfillment of the
       Requirements for the Degree\\
       {\@degree}
       
       % MATH: Additional text to match Grad School
		\vspace{2\baselineskip}
		University of Louisiana at Lafayette\\
		Fall 2025
    \fi
    %\ \\
    %by\\
    %\ \\
    \ \\
    %{\@author}\\
    %\vspace*{8\baselineskip}
    %\vspace*{3in}
    %In Partial Fulfillment \\
    %of the Requirements for the Degree \\
    %{\@degree} %in
    %\iflistmajor
    %   \\ {\@major}\\
    %   \vfill
    %   {\@department}\\
    %\else
    %   the\\ {\@department}\\
    %   \vfill
    %\fi
    
% MATH: Removed this part, copyright does not come directly after
% the title any more
%    \vspace*{6\baselineskip}
%       {\@author}\\
%    \ \\
%    {\@submitdate}
%    \clearpage
%    %\vspace*{7in}
%    \vspace*{35\baselineskip}
%    \thispagestyle{empty}
%    \copyright{} {\@author}\\
%    \ \\ \@copyrightyear\\
%    \ \\ All Rights Reserved
%    %\ifcopyright
%      %\\ \vspace*{.3in}% one line + 0.3in
%      %Copyright \copyright\ {\@copyrightyear} by {\@author}
%    %\fi
  \end{center}
}

\newcommand{\make@parttitle}[1]{%if argument is present, it's the part title 
  \begingroup
    \newlinestretch{1}%
    \phantomsection%
    \title@top
    \ifstrictmargins
      \vspace*{0.5in}
      \begin{center}
        \begin{doublespaced}{\large\bfseries%
          \expandafter{\textbf{\partname}\space\textbf{\thepart}}\\
          \ifx\@empty#1\@empty\else%
            \expandafter{#1}\\
          \fi%
        }\end{doublespaced}
        \ \\
        by\\
        \ \\
        {\@author}\\
      \end{center}%
      \vfill
    \else%
      \vspace*{0.5in}
      \begin{center}
        \begin{doublespaced}{\Huge\bfseries%
          \expandafter{\textbf{\partname}\space\textbf{\thepart}}\\
          \ifx\@empty#1\@empty\else%
            \expandafter{#1}\\
          \fi%
        }\end{doublespaced}
        \vspace*{1.35in}
        \ \\
        by\\
        \ \\
        {\Large\bfseries{\@author}}\\
      \end{center}%
      \vfill
    \fi%
  \endgroup%
}%makeparttitle

\renewcommand{\maketitle}{%
  %\interlinepenalty \@M
  \normalfont
  \begingroup
    \newlinestretch{1}%
    \begin{titlepage}%
      \phantomsection%
       \pdfbookmark[0]{Titlepage}{title}%
      \title@top%
      \ifstrictmargins%
        %\vfill
        \vspace*{6\baselineskip}
        \title@text% contains a \vfill between \degree and \department
      \else%
        \vfill%\vspace*{1.35in}
        \title@text% contains a \vfill between \degree and \department
        \vspace*{.2in}%
      \fi%
      \setcounter{page}{2}%
    \end{titlepage}% this has a \newpage
  \endgroup%
  \setcounter{page}{3}%
}%maketitle



% Abstract
% make sure geometry exists but doesn't change global layout
\PassOptionsToPackage{pass}{geometry}
\RequirePackage{geometry}

% knob: distance from "Abstract" heading to first paragraph
% (safe to redefine elsewhere with \renewcommand)
\providecommand{\AbstractAfterHeadingSkip}{\baselineskip}

%% Change \begin{abstract}...\end{abstract} to follow guidelines
%% and put the abstract on a separate page (checking @openright).
%
\renewenvironment{abstract}{%
  \typeout{*****************      Abstract     ******************}
  \if@openright\cleardoublepage\else\clearpage\fi 
  \addtocounter{page}{0} 
  \phantomsection%
  \addcontentsline{toc}{chapter}%
    {\texorpdfstring{\textbf{Abstract}}{Abstract}}

    \vspace*{-0.63in}
    %\vskip 0.25in
    \begin{center}
    % MATH: Make sure that Abstract heading is correctly formatted
    % No need for the \chapter* command, since Abstract is added to TOC
    % above manually
    \chapterheadingsize{\textbf{Abstract}}
    \end{center}
    \vskip -0.4in
    % MATH: Correct spacing after the Abstract heading
    % (Should be like regular double spaced text)
    \vspace*{-13pt}
  \begingroup%
    \hspace*{2.5em}%
    %% Adjust the line spacing: if it was less than 1 1/2,
    %% increase it to 1 1/2; if it was between 1 1/2 and 2,
    %% increase it to 2; otherwise, leave it as is.
    \ifdim \baselinestretch pt < 1.25pt \newlinestretch{1.25}\else%
    \ifdim \baselinestretch pt < 1.66pt \newlinestretch{1.66}\fi\fi%
}{\par\endgroup}%abstract
%
%% \begin{biosketch}...\end{biosketch} formats an
%% biosketch section




%% \begin{biosketch}...\end{biosketch} formats an
%% biosketch section
\newenvironment{biosketch}{%
  \typeout{***************** Biographical Sketch ******************}
  \if@openright\cleardoublepage\else\clearpage\fi 
  \phantomsection%
  \addcontentsline{toc}{chapter}%
    {\texorpdfstring{\textbf{Biographical Sketch}}{Biographical Sketch}}
  %\chapter*{\MakeUppercase{Biographical Sketch}}
  \begin{center}
  {\bfseries{\textbf{Biographical Sketch}}}
  \end{center}
  % MATH: Fixed spacing after Biographical Sketch heading
  % Should be like regular double spaced text
  \vskip -0.17in
  \begingroup
  %\thispagestyle{empty}
  \indent \indent
}{\par\endgroup}%Biographical Sketch
%
%% \begin{summary}...\end{summary} formats a 
%% summary section (identical to an abstract section,
%% except that the title is ``SUMMARY'')
%
\newenvironment{summary}{%
  \typeout{*****************       Summary     ******************}
  \if@openright\cleardoublepage\else\clearpage\fi 
  \phantomsection%
  \addcontentsline{toc}{chapter}%
    {\texorpdfstring{\textbf{Summary}}{Summary}}
  \chapter*{\textbf{Summary}}
  \vskip 0.5in
  \begingroup
    \hspace*{2.5em}
    %% Adjust the line spacing: if it was less than 1 1/2,
    %% increase it to 1 1/2; if it was between 1 1/2 and 2,
    %% increase it to 2; otherwise, leave it as is.
    \ifdim \baselinestretch pt < 1.25pt \newlinestretch{1.25}\else
    \ifdim \baselinestretch pt < 1.66pt \newlinestretch{1.66}\fi\fi
}{\par\endgroup}%summary
%
%% \begin{dedication}...\end{dedication} formats a
%% dedication section
%
\newcommand{\dedicationtop}{\vspace*{\stretch{1}}}
\newcommand{\dedicationbottom}{\bigskip\bigskip\vspace*{\stretch{1}}}
\newenvironment{dedication}{%
  \typeout{*****************    Dedication    ******************}
  \if@openright\cleardoublepage\else\clearpage\fi 
  \phantomsection%
 \addcontentsline{toc}{chapter}%
   {\texorpdfstring{\textbf{Dedication}}{Dedication}}
  \ifdedicationheading
        \chapter*{\normalsize{\textbf{Dedication}}}
  \else
    \chapter*{}
  \fi
  %\vskip -0.25in
  \vspace*{-\baselineskip}
  \begingroup
  \indent\indent 
  %\begin{itshape}\dedicationtop
  % \thispagestyle{empty}
}{\par\endgroup}%dedication
%
%% \begin{acknowledgements}...\end{acknowledgements} formats an
%% acknowledgements section
%
\newenvironment{acknowledgements}{%
  \typeout{***************** Acknowledgments ******************}
  \if@openright\cleardoublepage\else\clearpage\fi 
  \phantomsection%
  \addcontentsline{toc}{chapter}%
    {\texorpdfstring{\textbf{Acknowledgments}}{Acknowledgments}}
  % MATH: Make sure that Acknowledgments heading is correctly formatted
  \chapter*{{\chapterheadingsize \textbf{Acknowledgments}}}
  %\vskip -0.5in
  \vspace*{-2\baselineskip}
  \begingroup
  \indent\indent 
  %\thispagestyle{empty}
}{\par\endgroup}%Acknowledgments
%
%comment this environment if you don't have any list of abbreviations
\newenvironment{listofabbreviations}{%
  \typeout{***************** List of Abbreviations ******************}
  \if@openright\cleardoublepage\else\clearpage\fi 
  \phantomsection%
  \addcontentsline{toc}{chapter}%
    {\texorpdfstring{\textbf{List of Abbreviations}}{List of Abbreviation}}
  % MATH: Make sure that List of Abbreviations heading is correctly formatted
  \chapter*{\chapterheadingsize{\textbf{List of Abbreviations}}}
  %\vskip -.5in
  \vspace*{-1\baselineskip}
  %\begingroup
  %\indent\indent 
  %\thispagestyle{empty}
}%{\par\endgroup}

%% \begin{epigraph}...\end{epigraph} formats a
%% dedication section
%
%\newcommand{\epigraphtop}{\vspace*{\stretch{1}}}
%\newcommand{\epigraphbottom}{\bigskip\bigskip\vspace*{\stretch{1}}}
\newenvironment{epigraph}{%
  \typeout{*****************    Epigraph    ******************}
  \if@openright\cleardoublepage\else\clearpage\fi 
  \phantomsection%
 \addcontentsline{toc}{chapter}%
   {\texorpdfstring{\textbf{Epigraph}}{Epigraph}}
  \ifdedicationheading
    \chapter*{\normalsize{\textbf{Epigraph}}}
  \else
    \chapter*{}
  \fi
  \vspace{-0.3\baselineskip}
  \begingroup
  %\epigraphtop
  % \thispagestyle{empty}
}{\par\endgroup}%epigraph
%
%% \begin{preface}...\end{preface} formats an
%% preface section
%
\newenvironment{preface}{%
  \typeout{*****************      Preface     ******************}
  \if@openright\cleardoublepage\else\clearpage\fi 
  \phantomsection%
  \addcontentsline{toc}{chapter}%
    {\texorpdfstring{\textbf{Preface}}{Preface}}
  \chapter*{\textbf{Preface}}
  \vskip 0.5in
  \begingroup
}{\par\endgroup}%preface

%
%% stuff to generate a signature page
%
\newlength{\signature@width}
\setlength{\signature@width}{3.3in}
\let\signature@body\signature@bodyonecol
\newcounter{signatures}
\newcounter{cnt@Lsig}
\newcounter{cnt@Rsig}
\def\R@signatures{}
\def\L@signatures{}

% Fun stuff from the TeXbook
\toksdef\ta=0 \toksdef\tb=2 % token list registers for temp use
\long\def\leftappenditem#1\to#2{\ta={\\{#1}}\tb=\expandafter{#2}%
  \edef#2{\the\ta\the\tb}}
\long\def\rightappenditem#1\to#2{\ta={\\{#1}}\tb=\expandafter{#2}%
  \edef#2{\the\tb\the\ta}}
\def\concatenate#1=#2&#3{\ta=\expandafter{#2}\tb=\expandafter{#3}%
  \edef#1{\the\ta\the\tb}}
\def\GTlop#1\to#2{\expandafter\GTlopoff#1\GTlopoff#1#2}
\long\def\GTlopoff\\#1#2\GTlopoff#3#4{\def#4{#1}\def#3{#2}}

\newcommand{\dosiglist}[2]{%
  \GTlop#1\to\@@sig \@@sig
  \GTlop#1\to\@@sig \@@sig
  \GTlop#1\to\@@sig \@@sig
  % we know that cnt@Lsig is at least 3, maybe 4. 5 is right out.
  \ifnum \value{#2} = 4
    \GTlop#1\to\@@sig \@@sig
  \fi
}

\newcommand{\signature}[1]{%
  \ifx\empty#1\empty\else
    \parbox[t]{\signature@width}{%
      \GTlop#1\to\signame%
      \GTlop#1\to\sigdept%
      \GTlop#1\to\siginst%
      % no trailing \\ after this inner parbox
      \parbox[t]{\signature@width}{\raggedleft
        \signame \hfill\\
        \sigdept\hfill\\
        \siginst
      }\hfill
      \vspace{14pt}% spacing between signatures (global knob)
    }%
  \fi
}



\newcommand{\signature@bodyonecol}{%
  \noindent\begin{minipage}[t]{\textwidth}
    \raggedleft\textbf{APPROVED:}\par\vspace{12pt}

    % local copies of counts for safe pops
    \newcounter{gt@Lleft}\setcounter{gt@Lleft}{\value{cnt@Lsig}}%
    \newcounter{gt@Rleft}\setcounter{gt@Rleft}{\value{cnt@Rsig}}%

    % --- SAFE POP HELPERS (use ##1 since we're inside a macro definition!) ---
    \def\gt@popL##1{%
      \ifnum\value{gt@Lleft}>0
        \GTlop\L@signatures\to##1%
        \addtocounter{gt@Lleft}{-1}%
      \else
        \let##1\@empty
      \fi
    }%
    \def\gt@popR##1{%
      \ifnum\value{gt@Rleft}>0
        \GTlop\R@signatures\to##1%
        \addtocounter{gt@Rleft}{-1}%
      \else
        \let##1\@empty
      \fi
    }%

    % pull up to 8 from LEFT (Chair first) and RIGHT (Dean ends up here)
    \gt@popL\@@sigLone
    \gt@popL\@@sigLtwo
    \gt@popL\@@sigLthree
    \gt@popL\@@sigLfour
    \gt@popL\@@sigLfive
    \gt@popL\@@sigLsix
    \gt@popL\@@sigLseven
    \gt@popL\@@sigLeight

    \gt@popR\@@sigRone
    \gt@popR\@@sigRtwo
    \gt@popR\@@sigRthree
    \gt@popR\@@sigRfour
    \gt@popR\@@sigRfive
    \gt@popR\@@sigRsix
    \gt@popR\@@sigRseven
    \gt@popR\@@sigReight

    % print only real entries (no extra \\ or \vspace here)
    {%
      \def\gt@printsig##1{\ifx##1\@empty\else ##1\fi}%
      \hfill\begin{minipage}[t]{\signature@width}\raggedleft
        % LEFT first -> Chair first
        \gt@printsig{\@@sigLone}
        \gt@printsig{\@@sigLtwo}
        \gt@printsig{\@@sigLthree}
        \gt@printsig{\@@sigLfour}
        \gt@printsig{\@@sigLfive}
        \gt@printsig{\@@sigLsix}
        \gt@printsig{\@@sigLseven}
        \gt@printsig{\@@sigLeight}
        % RIGHT next -> Dean (appended to RIGHT) is last overall
        \gt@printsig{\@@sigRone}
        \gt@printsig{\@@sigRtwo}
        \gt@printsig{\@@sigRthree}
        \gt@printsig{\@@sigRfour}
        \gt@printsig{\@@sigRfive}
        \gt@printsig{\@@sigRsix}
        \gt@printsig{\@@sigRseven}
        \gt@printsig{\@@sigReight}
      \end{minipage}%
    }%
  \end{minipage}%
}


\newcommand{\signature@bodytwocol}{%
  \noindent\begin{minipage}[t]{\textwidth}
    \raggedleft\textbf{APPROVED:}\par\vspace{12pt}

    % --- LEFT column (up to 8 names) ---
    \GTlop\L@signatures\to\@@sigLone%
    \GTlop\L@signatures\to\@@sigLtwo%
    \GTlop\L@signatures\to\@@sigLthree%
    \ifnum\value{cnt@Lsig}>3 \GTlop\L@signatures\to\@@sigLfour \else \def\@@sigLfour{} \fi
    \ifnum\value{cnt@Lsig}>4 \GTlop\L@signatures\to\@@sigLfive \else \def\@@sigLfive{} \fi
    \ifnum\value{cnt@Lsig}>5 \GTlop\L@signatures\to\@@sigLsix  \else \def\@@sigLsix{}  \fi
    \ifnum\value{cnt@Lsig}>6 \GTlop\L@signatures\to\@@sigLseven \else \def\@@sigLseven{} \fi
    \ifnum\value{cnt@Lsig}>7 \GTlop\L@signatures\to\@@sigLeight \else \def\@@sigLeight{} \fi
    
    % --- RIGHT column (up to 8 names) ---
    \GTlop\R@signatures\to\@@sigRone%
    \GTlop\R@signatures\to\@@sigRtwo%
    \GTlop\R@signatures\to\@@sigRthree%
    \ifnum\value{cnt@Rsig}>3 \GTlop\R@signatures\to\@@sigRfour \else \def\@@sigRfour{} \fi
    \ifnum\value{cnt@Rsig}>4 \GTlop\R@signatures\to\@@sigRfive \else \def\@@sigRfive{} \fi
    \ifnum\value{cnt@Rsig}>5 \GTlop\R@signatures\to\@@sigRsix  \else \def\@@sigRsix{}  \fi
    \ifnum\value{cnt@Rsig}>6 \GTlop\R@signatures\to\@@sigRseven \else \def\@@sigRseven{} \fi
    \ifnum\value{cnt@Rsig}>7 \GTlop\R@signatures\to\@@sigReight \else \def\@@sigReight{} \fi
        

    \begin{tabular*}{\textwidth}[t]{@{\extracolsep{\fill}}ll}
      \@@sigLone   & \@@sigRone\\%
      \@@sigLtwo   & \@@sigRtwo\\%
      \@@sigLthree & \@@sigRthree\\%
      \@@sigLfour  & \@@sigRfour\\%
      \@@sigLfive  & \@@sigRfive\\%
      \@@sigLsix   & \@@sigRsix\\%
      \@@sigLseven & \@@sigRseven\\%
      \@@sigLeight & \@@sigReight\\%
    \end{tabular*}
  \end{minipage}%
}



\def\add@Lsig#1{
  \ifx#1\@empty\relax\else%
    \rightappenditem#1\to\L@signatures
    \addtocounter{cnt@Lsig}{1}%
  \fi
}
\def\add@Rsig#1{%
  \ifx\@empty#1\relax\else
    \rightappenditem#1\to\R@signatures
    \addtocounter{cnt@Rsig}{1}%
  \fi
}
\newcommand{\makesignature}{%
  \if@openright\cleardoublepage\else\clearpage\fi 
  \phantomsection%
  \pdfbookmark[0]{Signatures}{signatures}%
  % do not addtocontents (although it is in bookmarklist)
  \ifx\@empty\@committeechair\relax\else
    \addtocounter{signatures}{1}%
        \GTlop\@committeechair\to\z%
        \leftappenditem{\z, \mbox{Chair}}\to\@committeechair%
    \add@Lsig{\signature{\@committeechair}}
  \fi
  \ifx\@empty\@principaladvisor\relax\else
    \addtocounter{signatures}{1}%
      \GTlop\@principaladvisor\to\a%
      \leftappenditem{\a}\to\@principaladvisor%      
    \add@Lsig{\signature{\@principaladvisor}}
  \fi
  \ifx\@empty\@firstreader\relax\else
    \addtocounter{signatures}{1}%
    \add@Lsig{\signature\@firstreader}
  \fi
% The first three will ALWAYS be in the left column, but now we must compute
% the total number of sigs before doing anything else.
  \ifx\@empty\@secondreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@thirdreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@fourthreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@fifthreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@sixthreader\relax\else\addtocounter{signatures}{1}\fi \ifx\@empty\@seventhreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@eighthreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@ninthreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@tenthreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@eleventhreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@twelfthreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@thirteenthreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@fourteenthreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@fifteenthreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@sixteenthreader\relax\else\addtocounter{signatures}{1}\fi
  \ifx\@empty\@deanreader\relax\else\addtocounter{signatures}{1}\fi
  
  %How many total sigs go in first column
  \typeout{SIGNATURES: \arabic{signatures}}
  \ifnum \value{signatures} < 10 % fuggeddaboutit.  Only one column.
  %                                 ^  x-D - hahaha duly noted my friend
    \let\signature@body\signature@bodyonecol
    \setlength{\signature@width}{0.52\textwidth}
  \else
    \let\signature@body\signature@bodytwocol
    \setlength{\signature@width}{0.46\textwidth}
  \fi
  
  % \newcounter{halfsig}
  % \setcounter{halfsig}{\value{signatures} - (\value{signatures} / 2)}

  % Cap left column to 6 rows so it fits one page with 12pt
  \newcounter{maxleft}
  \setcounter{maxleft}{8}

  % Helper: place one entry either LEFT (if we still need to fill up to half and under cap) or RIGHT
% Helper: place one entry to keep columns balanced, reserving Dean on RIGHT
    \def\place@sig##1{%
      \ifx\@empty##1\relax\else
        % If LEFT column is full, force RIGHT
        \ifnum\value{cnt@Lsig}>\numexpr\value{maxleft}-1\relax
          \add@Rsig{\signature##1}%
        \else
          % Predictive balance: treat RIGHT as if it already has Dean (+1)
          \ifnum\value{cnt@Lsig}>\numexpr\value{cnt@Rsig}+1\relax
            \add@Rsig{\signature##1}%
          \else
            \add@Lsig{\signature##1}%
          \fi
        \fi
      \fi
    }


  % Fill in order after \@firstreader
  \place@sig\@secondreader
  \place@sig\@thirdreader
  \place@sig\@fourthreader
  \place@sig\@fifthreader
  \place@sig\@sixthreader
  \place@sig\@seventhreader
  \place@sig\@eighthreader
  \place@sig\@ninthreader
  \place@sig\@tenthreader
  \place@sig\@eleventhreader
  \place@sig\@twelfthreader
  \place@sig\@thirteenthreader
  \place@sig\@fourteenthreader

% Ensure Dean is last (always append to RIGHT stack)
\ifx\@empty\@deanreader\relax\else
  \add@Rsig{\signature\@deanreader}%
\fi




  % Guardrail: one signature page supports at most 12 names (6 per column)
  \ifnum\value{signatures}>16
    \ClassError{gatech-thesis}{Too many committee entries for one page (>\space 16).}{Reduce committee size or lower spacing.}
  \fi  

  % MATH: Fixed: No page number on Signature page
  \thispagestyle{empty}
  \ifstrictmargins
    \ifnum \@marginsize = 4 % oldmargins
      \vspace*{50\p@}%
    \fi
    % MATH: Fixed: The spacing here is obsolete
    %\vspace{7in}
    \begin{center}%
    \vspace*{4\baselineskip}
        \expandafter{\@title}\\%%%% TITLE FONT SIZE!!!!
        % MATH: Fixed spacing
        \vspace*{2\baselineskip}
        {\@author}
        % MATH: Fixed spacing
        \ \\
        \ \\
        % MATH: Added title text here on signature page!
        \title@text
    \end{center}%
  \else%
  % MATH: Removed title here
%  \vspace{5in}
%    \begin{center}
%%     \vspace*{\stretch{1}}
%      \vspace*{1in}
%        \expandafter{\@title}%%%%% TITLE FONT SIZE AGAIN
%        {\@author}
%    \end{center}%
  \fi%
  %\vfill
  % MATH: Fix spacing
\vspace*{2\baselineskip plus 1fill}
\noindent\signature@body
\ifstrictmargins\relax\else
  \vspace{.2in}\mbox{}
\fi
\thispagestyle{empty}


  
% MATH: Added copyright page to the signature page command
% Belonged to title page before, is now here
% Because it comes right after the title/signature page
% Clearpage to have it on next page
% \clearpage
% %\vspace*{7in}
% \vspace*{\fill}% push everything down to the bottom of the text block (respects 1" bottom margin)
% \begine{singlespaced}
% \begin{center}
%   \thispagestyle{empty}
%   \copyright{} {\@author}\\
%   \ \\ \@copyrightyear\\
%   \ \\ All Rights Reserved
% \end{center}
% \end{singlespaced}
% % no extra vertical space after; the block sits at the bottom margin
% \setcounter{page}{2}
% }

\clearpage
\vspace*{\fill}
\begin{singlespaced}
\begin{center}
  \thispagestyle{empty}
  \copyright{} {\@author}\\
  ORCID: 0000-0002-1825-0097\\
  \@copyrightyear\\
  All Rights Reserved
\end{center}
\end{singlespaced}
}
%
%% beforepreface
%
\newcommand{\beforepreface}{%
  \newlinestretch{1.0}%
  \pagenumbering{roman}%
  \pagestyle{\front@pagestyle}%
  \iftitlepage%
    \maketitle%
  \fi%
  \ifmultivolume%
    \part{}%
  \fi%
  \ifsignaturepage%
    \makesignature%
  \fi%
  \newlinestretch{\@spacing}%
}

%
%% \prefacesection is here for backward compatibility with
%% the GT-thesis.sty package, and to add preface sections
%% that are not already defined.  For Abstract, Preface,
%% Dedication, and Acknowlegements sections, use the 
%% appropriate environments: \begin{abstract}...\end{abstract}
%% etc.
%
\newcommand{\prefacesection}[1]{%
  \if@openright\cleardoublepage\else\clearpage\fi 
  \phantomsection%
  \addcontentsline{toc}{chapter}%
    {\texorpdfstring{\textbf{#1}}{#1}}
  \newlinestretch{\@spacing}
  \chapter*{\textbf{#1}}
  \vskip 0.5in
}
\newcommand{\afterpreface}{%
  \if@draft%
  \else%
    \if@twoside%
      \if@openright%
        \cleardoublepage%
      \fi%
    \fi%
  \fi%
  \newpage%
  \pagenumbering{arabic}%
  \pagestyle{\body@pagestyle}%
  \newlinestretch{\@spacing}%
}

% dummy commands to prevent recursion errors...
\newcommand{\gtcontentsname}{}
\newcommand{\toccontentlinestring}{}
\newcommand{\tocpdfbookmarkstring}{}
\newcommand{\gtlistfigurename}{}
\newcommand{\lofcontentlinestring}{}
\newcommand{\lofpdfbookmarkstring}{}
\newcommand{\gtlisttablename}{}
\newcommand{\lotcontentlinestring}{}
\newcommand{\lotpdfbookmarkstring}{}

\newcommand{\settocstring}[1]{%
  \renewcommand{\gtcontentsname}{#1}
  \renewcommand{\contentsname}{\normalsize{\textbf{#1}}\hfill}
  \renewcommand{\toccontentlinestring}{%
    \textbf{#1}
  }
  \renewcommand{\tocpdfbookmarkstring}{#1}
}
\newcommand{\setlofstring}[1]{%
  \renewcommand{\gtlistfigurename}{\textbf{#1}}
  \renewcommand{\listfigurename}{\normalsize\bfseries{#1}}
  \renewcommand{\lofcontentlinestring}{%
    \textbf{#1}
    %\texorpdfstring{\Makeuppercase{#1}}{#1}
  }
  \renewcommand{\lofpdfbookmarkstring}{#1}
}
\newcommand{\setlotstring}[1]{%
  \renewcommand{\gtlisttablename}{#1}
  \renewcommand{\listtablename}{\normalsize{\textbf{#1}}}
  \renewcommand{\lotcontentlinestring}{%
    \textbf{#1}
    %\texorpdfstring{\Makeuppercase{#1}}{#1}
  }
  \renewcommand{\lotpdfbookmarkstring}{#1}
}
\settocstring{Table of Contents}
\setlofstring{List of Figures}
\setlotstring{List of Tables}

%
%% All this junk is for handling the spacing in the TOC, LOF, and LOT.
%
\newlength{\gt@tocentryskip@value}
\newlength{\gt@beforepartskip@value}
\newlength{\gt@beforechapskip@value}
\newlength{\gt@beforesecskip@value}
\newlength{\gt@beforesubsecskip@value}
\newlength{\gt@beforesubsubsecskip@value}
\newlength{\gt@beforeparaskip@value}
\newlength{\gt@beforesubparaskip@value}
\newlength{\gt@beforefigskip@value}
\newlength{\gt@beforetableskip@value}

\def\set@gttocskip#1{%
  \setlength{\gt@tocentryskip@value}{#1}
  % set base lengths
  \setlength{\gt@beforepartskip@value}{2\gt@tocentryskip@value}
  \setlength{\gt@beforechapskip@value}{1.5\gt@tocentryskip@value}
  \setlength{\gt@beforesecskip@value}{\gt@tocentryskip@value}
  \setlength{\gt@beforesubsecskip@value}{\gt@tocentryskip@value}
  \setlength{\gt@beforesubsubsecskip@value}{\gt@tocentryskip@value}
  \setlength{\gt@beforeparaskip@value}{\gt@tocentryskip@value}
  \setlength{\gt@beforesubparaskip@value}{\gt@tocentryskip@value}
  \setlength{\gt@beforefigskip@value}{\gt@tocentryskip@value}
  \setlength{\gt@beforetableskip@value}{\gt@tocentryskip@value}
  % add glue
  \addtolength{\gt@beforepartskip@value}{\z@ \@plus\p@}
  \addtolength{\gt@beforechapskip@value}{\z@ \@plus\p@}
  \addtolength{\gt@beforesecskip@value}{\z@ \@plus.2\p@}
  \addtolength{\gt@beforesubsecskip@value}{\z@ \@plus.2\p@}
  \addtolength{\gt@beforesubsubsecskip@value}{\z@ \@plus.2\p@}
  \addtolength{\gt@beforeparaskip@value}{\z@ \@plus.2\p@}
  \addtolength{\gt@beforesubparaskip@value}{\z@ \@plus.2\p@}
  \addtolength{\gt@beforefigskip@value}{\z@ \@plus.2\p@}
  \addtolength{\gt@beforetableskip@value}{\z@ \@plus.2\p@}
}
\set@gttocskip{10pt}

% gobble the pagenumber
\newcommand*{\l@part@pagenumfont}[1]{}
% note: we don't do the fancy volume title centering here, because
% we use {part} for the \labelchaptersintableofcontents stuff.  And
% that is NOT centered.
\renewcommand*{\l@part}[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{\gt@beforepartskip@value}%
    \setlength\@tempdima{3em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \interlinepenalty\@M
      {\leavevmode #1\hfil \hb@xt@\@pnumwidth{\hss \l@part@pagenumfont{#2}}}\par
       \nobreak
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
    \endgroup
  \fi}
\newcommand*{\gt@dottedtocline}[5]{%
  \ifnum #1>\c@tocdepth \else
    \addvspace{\gt@@toclineskip}
    {\leftskip #2\relax \rightskip \@tocrmarg \parfillskip -\rightskip
     \parindent #2\relax\@afterindenttrue
     \interlinepenalty\@M
     \leavevmode
     \@tempdima #3\relax
     \advance\leftskip \@tempdima \null\nobreak\hskip -\leftskip
     {#4}\nobreak
     \leaders\hbox{$\m@th
        \mkern \@dotsep mu\hbox{.}\mkern \@dotsep
        mu$}\hfill
     \nobreak
     \hb@xt@\@pnumwidth{\hfil\normalfont \normalcolor #5}%
     \par}%
  \fi}
\renewcommand*\l@chapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \addvspace{\gt@beforechapskip@value}%
    \setlength\@tempdima{2em}% was 1.5em, but that's too small.  Add 0.5em to all others
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\normalfont\normalcolor
      \leaders\hbox{$\m@th
        \mkern \@dotsep mu\hbox{.}\mkern \@dotsep
	mu$}\hfill
      \nobreak
      \hb@xt@\@pnumwidth{\hss\bfseries #2}
      \par
      \penalty\@highpenalty
    \endgroup
  \fi}
  
\renewcommand*\l@section{%
  \let\gt@@toclineskip=\gt@beforesecskip@value
  \gt@dottedtocline{1}{0.5in}{0.5in}}
\renewcommand*\l@subsection{%
  \let\gt@@toclineskip=\gt@beforesubsecskip@value
  \gt@dottedtocline{2}{1.0in}{0.5in}}
\renewcommand*\l@subsubsection{%
  \let\gt@@toclineskip=\gt@beforesubsubsecskip@value
  \gt@dottedtocline{3}{1.5in}{0.5in}}
\renewcommand*\l@paragraph{%
  \let\gt@@toclineskip=\gt@beforeparaskip@value
  \gt@dottedtocline{4}{2.0in}{0.5in}}
\renewcommand*\l@subparagraph[2]{%
  \let\gt@@toclineskip=\gt@beforesubparaskip@value
  \ifnum\c@secnumdepth<5
    % not numbered -> keep the tab stop with an empty number box
    \gt@dottedtocline{5}{2.5in}{0.5in}{\numberline{}#1}{#2}%
  \else
    % numbered -> use entry as written in .toc
    \gt@dottedtocline{5}{2.5in}{0.5in}{#1}{#2}%
  \fi
}


\renewcommand*\l@figure{%

  \let\gt@@toclineskip=\gt@beforefigskip@value
  \gt@dottedtocline{1}{1.5em}{2.3em}
  
  \@afterindenttrue
	\let\@cftbsnum \cftfigpresnum
	\let\@cftasnum \cftfigaftersnum
	\let\@cftasnumb \cftfigaftersnumb
  }% this is indented 1.5em so that 
                                     % if you wish, you can a 'Figure' header
                                     % centered above the numbers using \addtocontents
\renewcommand*\l@table{%
  \let\gt@@toclineskip=\gt@beforetableskip@value
  \gt@dottedtocline{1}{1.5em}{2.3em}
  \@afterindenttrue
  }% ditto

\newlength{\gt@tmpa}
\newcommand{\do@figurespage}{%
  \iffigurespage
    \if@openright\cleardoublepage\else\clearpage\fi 
    % must clear page here, so that phantomsection\addcontentsline is on the correct page
    \phantomsection%
    \addcontentsline{toc}{chapter}{\lofcontentlinestring}
    \settoheight{\gt@tmpa}{A}
    \set@gttocskip{\gt@tmpa}
    {\newlinestretch{1}
     \listoffigures
    }
     \newpage
  \fi
}
\newcommand{\do@tablespage}{%
  \iftablespage
    \if@openright\cleardoublepage\else\clearpage\fi 
    % must clear page here, so that phantomsection\addcontentsline is on the correct page
    \phantomsection%
    \addcontentsline{toc}{chapter}{\lotcontentlinestring}
    \settoheight{\gt@tmpa}{A}
    \set@gttocskip{\gt@tmpa}
    {\newlinestretch{1}
     \listoftables
    }
    \newpage
  \fi
}
\newcommand{\do@contentspage}{%
  \ifcontentspage
    \if@openright\cleardoublepage\else\clearpage\fi 
    % must clear page here, so that phantomsection\addcontentsline is on the correct page
    \phantomsection%
    \pdfbookmark[0]{\tocpdfbookmarkstring}{toc}%
    \settoheight{\gt@tmpa}{A}
    \set@gttocskip{\gt@tmpa}
     {\newlinestretch{1}
     \tableofcontents
     }
    \newpage
  \fi
}
\newcommand{\do@losapage}{}
\newcommand{\do@glossarypage}{}
\newcommand{\do@indexpage}{}

\newcommand{\contents}{%
  \newpage
  \newlinestretch{\@spacing}
  \do@contentspage
  \do@tablespage
  \do@figurespage
  \do@losapage  
  \do@glossarypage  
}

%%%%%%    Main Matter Commands and Environments
%%
%% redefine chapter headings style
%% redefine appendix headings style
%% redefine section headings style
%% number figures and tables sequentially throughout, rather
%%   than restarting for each chapter.  Ditto equations.
%% redefine macro for floats (incl. figures and tables)
%%   so that single spacing is used
%% define a "gtindent" command for paragraph indents:
%%   blank line + six space first line indentation
%% settocdepth - use this to change how "deep" to number 
%%   in the table of contents for different sections; e.g.
%%   subsubsections for chapters, then switch to chapter-only
%%   for appendices.

% This package uses David Carlisle's \@removefromreset command as
% specified in the remreset package available from CTAN as
% macros/latex/contrib/supported/carlisle/remreset.sty
% It is \provided here as a convenience to the user, and with
% David Carlisle's permission.  remreset.sty is licensed under
% the LPPL; David has explicitly given permission to include
% it here, under the GPL.
% START OF DAVID CARLISLE'S CODE
%\newcommand{\@removefromreset}[2]{{%
%  \expandafter\let\csname c@#1\endcsname\@removefromreset
%  \def\@elt##1{%
%    \expandafter\ifx\csname c@##1\endcsname\@removefromreset
%    \else
%      \noexpand\@elt{##1}%
%    \fi}%
%  \expandafter\xdef\csname cl@#2\endcsname{%
%    \csname cl@#2\endcsname}}}
% END OF DAVID CARLISLE'S CODE
%%%%% See http://www.tex.ac.uk/cgi-bin/texfaq2html?label=running-nos

%
%% Figures and tables are to be numbered sequentially throughout the
%% thesis, rather than within chapters; for style consistency, do
%% equations the same. 
%
\@removefromreset{figure}{chapter}
\@removefromreset{table}{chapter}
\@removefromreset{equation}{chapter}
\def\thefigure{\@arabic\c@figure}
\def\thetable{\@arabic\c@table}
\def\theequation{\arabic{equation}}

%
%% Redefine the macro used for floats (including figures and tables)
%% so that single spacing is used.
%% (Note \def\figure{\@float{figure}set single spacing} doesn't work
%%  because figure has an optional argument)
%%
%% This code was copied directly from latex.ltx, but with the
%% \newlinespacing{} macro added to it.
%
\def\@xfloat #1[#2]{%
  \@nodocument
  \def \@captype {#1}%
   \def \@fps {#2}%
   \@onelevel@sanitize \@fps
   \def \reserved@b {!}%
   \ifx \reserved@b \@fps
     \@fpsadddefault
   \else
     \ifx \@fps \@empty
       \@fpsadddefault
     \fi
   \fi
   \ifhmode
     \@bsphack
     \@floatpenalty -\@Mii
   \else
     \@floatpenalty-\@Miii
   \fi
  \ifinner
     \@parmoderr\@floatpenalty\z@
  \else
    \@next\@currbox\@freelist
      {%
       \@tempcnta \sixt@@n
       \expandafter \@tfor \expandafter \reserved@a
         \expandafter :\expandafter =\@fps
         \do
          {%
           \if \reserved@a h%
             \ifodd \@tempcnta
             \else
               \advance \@tempcnta \@ne
             \fi
           \fi
           \if \reserved@a t%
             \@setfpsbit \tw@
           \fi
           \if \reserved@a b%
             \@setfpsbit 4%
           \fi
           \if \reserved@a p%
             \@setfpsbit 8%
           \fi
           \if \reserved@a !%
             \ifnum \@tempcnta>15
               \advance\@tempcnta -\sixt@@n\relax
             \fi
           \fi
           }%
       \@tempcntb \csname ftype@\@captype \endcsname
       \multiply \@tempcntb \@xxxii
       \advance \@tempcnta \@tempcntb
       \global \count\@currbox \@tempcnta
       }%
    \@fltovf
  \fi
  \global \setbox\@currbox
    \color@vbox
      \normalcolor
      \vbox \bgroup
        \newlinestretch{1.0}
        \hsize\columnwidth
        \@parboxrestore
        \@floatboxreset
}

% Redefine the macro used for caption labels, for a (slightly)
% fancier format.  Feel free to use the caption2 package instead...
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\textbf{#1: }#2}%
  \ifdim \wd\@tempboxa >\hsize
    \textsf{\textbf{#1: }}#2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

% Redefine the macro used for footnotes to use single spacing
\long\def\@footnotetext#1{%
  \insert\footins{%
    \newlinestretch{1.0}%
    \footnotesize%
    \interlinepenalty\interfootnotelinepenalty%
    \splittopskip\footnotesep%
    \splitmaxdepth \dp\strutbox \floatingpenalty \@MM%
    \hsize\columnwidth \@parboxrestore%
    \edef\@currentlabel{%
      \csname p@footnote\endcsname\@thefnmark%
    }%
    \@makefntext%
    {\rule{\z@}{\footnotesep}\ignorespaces%
      #1\strut}%
  }%
}

%
%% Paragraph indents (6 spaces)
%% inserts a blank line and then indents the paragraph by 6 spaces
%
\newcommand{\gtindent}{\par \hspace{0.25in}}

%
%% Chapter headings - centered, all caps, chapter number - roman numeral
%
%
%% Use \labelchaptersintableofcontents to insert an entry into the toc
%% that says ``CHAPTERS'' just before Chapter 1.
%  Use \labelappendicesintableofcontents to insert an entry into the toc
%% that says ``APPENDICES'' just before Appendix A.
%
\let\orig@contentsline=\contentsline
\newcommand{\labelchaptersintableofcontents}[1][CHAPTERS]{%
  \addtocontents{toc}{\protect\orig@contentsline{part}{#1}{}}
}
\newcommand{\labelappendicesintableofcontents}[1][APPENDICES]{%
  \addtocontents{toc}{\protect\orig@contentsline{part}{#1}{}}%
}

%\renewcommand{\chaptername}{\normalsize{CHAPTER}}
\renewcommand{\chaptername}{\normalsize{}}
\renewcommand{\appendixname}{APPENDIX}
\renewcommand{\thepart}{\@Roman\c@part}
\renewcommand{\partname}{Volume}

%
%% \thegtchapter is used so that we can have ROMAN numbers in the 
%% chapter headings at the beginning of each chapter, but use
%% \thechapter for ARABIC numbers in the running heads on each
%% page within the chapter.
%%
%% You can Change this behavior by redefining \thegtchapter 
%% within your document:
%% \renewcommand{\thegtchapter}{\thechapter}
%
\newcommand{\thegtchapter}{}%{\@Roman\c@chapter}
\def\chapapp@tocdepth{\expandafter\chapter@tocdepth}
%
%% The following two def's provide the Indirection needed to work 
%% with hyperref package, since hyperref redefines @chapter and
%% @schapter
%
\def\chapapp@chapter{\chap@chapter}
\def\chapapp@schapter{\chap@schapter}
%
%% Make @chapter and @schapter wrappers for (chap@chapter or app@chapter)
%% and (chap@schapter or app@schapter).  This indirection is necessary to
%% work well with the hyperref package.
%
\def\my@empty{}
\def\@chapter[#1]#2{%
  \def\my@temp{#1}%
  \ifx\my@temp\my@empty
    \chapapp@chapter{#2}
  \else
    \chapapp@chapter[#1]{#2}
  \fi
}
\def\@schapter#1{%
  \chapapp@schapter{#1}
}
%
%% The actual guts of the chapter heading routines
%
\renewcommand{\chapter}{%
  \if@openright\cleardoublepage\else\clearpage\fi
  \if@tcpage% DO NOT use the \front@pagestyle macro here.
    %{\thispagestyle{tcplain}}
    {\thispagestyle{empty}}
  \else
    {\thispagestyle{plain}}%report.cls temporarily resets pagestyle to plain. Do the same.
    %{\thispagestyle{empty}}

  \fi 
  \settocdepth{\chapapp@tocdepth}
  \global\@topnum\z@
  %\@afterindentfalse
  \secdef\@chapter\@schapter
}

\def\chap@chapter[#1]#2{%
  \ifnum \c@secnumdepth >\m@ne
    \refstepcounter{chapter}%
    \typeout{\@chapapp\space\thegtchapter.}%
    \addcontentsline{toc}{chapter}%
      {\texorpdfstring%
      	% MATH: Added space after the chapter number in chapter heading
        {\protect{\thegtchapter}\textbf{\space#1}}%{\protect\numberline{\thegtchapter}\textbf{#1}}%
       % {Chapter \thechapter\space\textemdash\space#1}}%
        {\thechapter\space\textemdash\space#1}}%
  \else
    \addcontentsline{toc}{chapter}%
    % MATH: Add space after chapter number in TOC as well
      {\texorpdfstring{\textbf{\space#1}}{\space#1}}%
  \fi
  \chaptermark{#1}%
  \if@twocolumn
    \@topnewpage[\@makechapterhead{#2}]%
  \else
    \@makechapterhead{#2}%
    \@afterheading
  \fi
}
% Make chapter headings on single line
\def\@makechapterhead#1{%
  \ifnum \@marginsize = 4 % oldmargins
    \vspace*{50\p@}%
  \fi
  { \parindent \z@ \raggedright \normalfont
    \ifnum \c@secnumdepth >\m@ne
      % MATH: Removed the text "Chapter" from chapter headings
      \centering \chapterheadingsize \bfseries\thegtchapter \space\textbf{#1}
      \par\nobreak
      \vspace*{0.05\baselineskip}% one double-spaced line after the title
      % MATH: Not necessary?
      %\vskip 6\p@
    \fi
    %\vskip -0.25in
    %\vskip -0.37in
    % MATH: Remove this spacing
    %\vskip 12pt
    %\interlinepenalty\@M
    %\centering \textbf{#1}\par\nobreak
    %\vskip 30\p@
    %\vskip 0.08in
  }
% Make chapter headings with chapter number and title on separate lines
%\def\@makechapterhead#1{%
%  \ifnum \@marginsize = 4 % oldmargins
%    \vspace*{50\p@}%
%  \fi
%  { \parindent \z@ \raggedright \normalfont
%    \ifnum \c@secnumdepth >\m@ne
%      \centering \large \bfseries \@chapapp\space \thegtchapter
%      \par\nobreak
%      \vskip 30\p@
%    \fi
%    %\vskip -0.25in
%    \vskip -0.37in
%    \interlinepenalty\@M
%    \centering \textbf{#1}\par\nobreak
%    %\vskip 30\p@
%    \vskip 0.08in
%  }
}
\def\chap@schapter#1{%
  \if@twocolumn
    \@topnewpage[\@makeschapterhead{#1}]%
  \else
    \@makeschapterhead{#1}%
    \@afterheading
  \fi
}
\def\@makeschapterhead#1{%
  \ifnum \@marginsize = 4 % oldmargins
    \vspace*{50\p@}%
  \fi
  { \parindent \z@ \raggedright \normalfont
    \interlinepenalty\@M
    \centering \large \bfseries #1\par\nobreak
    \vskip 30\p@
  }
}
%
%% Support for multi-volume thesis.
%%
%% in the premable, set \multivolumetrue and then
%% use the \part{} commannd where you want volume 2 
%% to begin, etc.  Do not give names to your volumes (that is,
%% use ``\part{}'' and not ``\part{Some title}''), because
%% the Graduate Office Guidelines do not allow separate
%% titles for each volume.
%
% we temporarily set the pagenumber to a big negative number, for
% two reasons: 1) so that it doesn't duplicate the other page numbers,
% because the volume title pages are unnumbered and uncounted.  We
% can't merely allow the autoincrement of pagenum and then addtocounter{page}{-1},
% because then both pages would have the same number. 2) it's a BIG negative
% number because we allow it to increment as each \part is declared, so that
% the volume title pages don't duplicate each others pagenums.
\newcounter{part@savepagenum}
\newcounter{part@pagenum}
\setcounter{part@pagenum}{-101} % can't have more than 50 parts,
% but this number must be odd, or twopage dvi's are messed up.
\renewcommand{\part}{%
  \if@openright\cleardoublepage\else\clearpage\fi
  \thispagestyle{empty}%
  \phantomsection%
  \setcounter{part@savepagenum}{\value{page}}
  \setcounter{page}{\value{part@pagenum}}
  \if@twocolumn
    \onecolumn
    \@tempswatrue
  \else
    \@tempswafalse
  \fi
  \secdef\@part\@spart}

\def\@part[#1]#2{%
  \ifnum \c@secnumdepth >-2\relax
    \refstepcounter{part}
    \typeout{\partname\space\thepart.}%
    \addcontentsline{toc}{part}%
      {\texorpdfstring%
        {\noindent\protect\makebox[\@tocrmarg]{}%
          {\protect\makebox[\textwidth - \@tocrmarg - \@tocrmarg]% dadgum \hfill doesn't work without mbox...
          {\hfill\textbf{\partname}\space\protect{\thepart}\hspace{1em}\textbf{#1}\hfill}}}%
        {Volume \thepart}}%
  \else
    \addcontentsline{toc}{part}%
    {\texorpdfstring%
      {\textbf{#1}}%
      {#1}}%
  \fi
  \markboth{}{}
  {\interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >-2\relax
       \make@parttitle{#1}
     \else
       \make@parttitle{}
     \fi}
     \@endpart}
\def\@spart#1{%
    {\interlinepenalty \@M
     \normalfont
     \make@parttitle{}}
    \@endpart}
\def\@endpart{%
  \vfill\newpage\addtocounter{part@pagenum}{1}%don't count this page
  \if@twoside
    \if@openright
      \null
      \thispagestyle{empty}%
      \newpage\addtocounter{part@pagenum}{1}%if we need to add another page, don't count it either
    \fi
  \fi
  \if@tempswa
    \twocolumn
  \fi
  \setcounter{page}{\value{part@savepagenum}}
}
%
%% Section
%% Heading 1: Large, bold, and italic, at left margin
%% Heading 2: Bold, at left margin
%% Heading 3: Italic, indented 0.25in from left margin
%
\renewcommand{\section}{%
  \@startsection{section}{1}{\z@}%
  {-0.25ex \@plus -1ex \@minus -0.2ex}%
  %{1.5ex \@minus-.5ex}%
  {0.0ex \@plus 0.2ex}
  % MATH: Fix spacing after Section headings
  % Should be like regular double-spaced text
  % NOTE: Latex does add or remove some space
  % on its own to make the pages fit
  {\newlinestretch{2}\bfseries}%
  %{\newlinestretch{1}\normalfont\large\bfseries\itshape}
}
\renewcommand{\subsection}{%
  \@startsection{subsection}{2}{\z@}%
  {-0.25ex\@plus -1ex \@minus -0.2ex}%
 % {-5pt}
  {0.0ex \@plus 0.2ex}%
  %{\newlinestretch{1}\normalfont\normalsize\bfseries}
  % MATH: Fix spacing after Subsection headings
  % Should be like regular double-spaced text
  % NOTE: Latex does add or remove some space
  % on its own to make the pages fit
  {\newlinestretch{2}\bfseries\normalsize\itshape}%
}
\renewcommand{\subsubsection}{%
  \@startsection{subsubsection}{3}{0.25in}%
  {-0.25ex\@plus -1ex \@minus -.2ex}%
  {-5pt}%
  %{1.5ex \@plus .2ex}%
  %{\newlinestretch{1}\normalfont\normalsize\itshape}
  {\bfseries\normalsize}%
}

\renewcommand{\appendix}{%
  \if@openright
    \cleardoublepage
  \else
    \clearpage
  \fi
  \renewcommand{\@chapapp}{\appendixname}
  \thispagestyle{plain}%    Do NOT use the \back@pagestyle macro here
  \settocdepth{\appendix@tocdepth}
  \setcounter{chapter}{0}%
  \setcounter{section}{0}%
  \def\thechapter{\@Alph\c@chapter}
  \def\chapapp@tocdepth{\expandafter\appendix@tocdepth}
  \def\chapapp@chapter{\app@chapter}
  \def\chapapp@schapter{\app@schapter}
  \renewcommand{\thesection}{\thechapter.\@arabic\c@section}
}
\def\app@chapter[#1]#2{%
  \ifnum \c@secnumdepth >\m@ne
    \refstepcounter{chapter}%
    \typeout{\@chapapp\space\thechapter.}%
    \addcontentsline{toc}{chapter}%
    {\texorpdfstring%
      {\@chapapp\space\protect\numberline{\thechapter}\space---\space\textbf{#1}}%
      {Appendix\space\thechapter\space\textemdash\space#1}}%must specify "---" explicitly here
  \else
    \addcontentsline{toc}{chapter}{\textbf\textit{#1}}%
  \fi
  \chaptermark{#1}%
  \if@twocolumn
    \@topnewpage[\@makeapphead{#2}]%
  \else
    \@makeapphead{#2}%
    \@afterheading
  \fi
}
\def\@makeapphead#1{%
  \ifnum \@marginsize = 4 % oldmargins
    \vspace*{50\p@}%
  \fi
  { \parindent \z@ \raggedright \normalfont
    \centering \bfseries \appendixname\space \thechapter
    \par\nobreak
    %\vskip -0.25in
    \interlinepenalty\@M
    \centering \bfseries \texfbf{#1}\par\nobreak
    %\vskip 35\p@
  }
}
\def\app@schapter#1{%
  \if@twocolumn
    \@topnewpage[\@makesapphead{#1}]%
  \else
    \@makesapphead{#1}%
    \@afterheading
  \fi
}
\def\@makesapphead#1{%
  \ifnum \@marginsize = 4 % oldmargins
    \vspace*{50\p@}%
  \fi
  { \parindent \z@ \raggedright \normalfont
    \interlinepenalty\@M
    \centering \large \bfseries #1\par\nobreak
    \vskip 30\p@
  }
}
%% end of \appendix environment definitions

%% \settocdepth - use this to change how "deep" to number 
%%   in the table of contents for different sections; e.g.
%%   subsubsections for chapters, then switch to chapter-only
%%   for appendices.
%% tocdepth is reset to the value in \setchaptertocdepth
%%   at each \chapter{}, or to the value in \setappendixtocdepth
%%   at each \chapter{} after the \appendix command.  So, if 
%%   you want to change the defaults, use \setchaptertocdepth and 
%%   \setappendixtocdepth.  To temporarily change depth for the 
%%   current section, use a different function: \settocdepth[x].  
%%   You should never need to call \setcounter{tocdepth}{..} 
%%   directly.
%%
%% 0 = chapter only
%% 1 = chapter + sections
%% 2 = chapter, section, subsection
%% 3 = chapter, section, subsection, subsubsection
%
\newcommand{\settocdepth}[1]{%
  \addtocontents{toc}{\protect\setcounter{tocdepth}{#1}}
}
\newcommand{\setappendixtocdepth}[1]{%
  \def\appendix@tocdepth{#1}
}
\newcommand{\setchaptertocdepth}[1]{%
  \def\chapter@tocdepth{#1}
}

%%%%%%    Back Matter Commands and Environments
%%
%% \beforepostface
%%   \thebibliography redefined so it matches GT's requirements
%%   \begin{vita}...\end{vita}
%%   \postfacesection{other-title}
%%     --- followed by section text
%% \afterpostface
%% \references
%%   --- creates the bibliography
%% \begin{postliminary}...\end{postliminary}
%%   --- preferred to \beforepostface and \afterpostface

% 
%%%%%%    New formatting environments and commands.
%
%% \begin{postliminary} sets the pagestyle for the
%% postliminary sections.  
%%
%% \end{postliminary} resets the pagestyle and
%% performs any other cleanup.
%
\newenvironment{postliminary}%
  {\pagestyle{\back@pagestyle}}%
  {\settocdepth{\chapter@tocdepth}%
   \pagestyle{\body@pagestyle}}

%
%% \begin{vita}...\end{vita} formats a
%% vita section
%
\newenvironment{vita}{%
  \typeout{*****************        Vita       ******************}
  \newlinestretch{\@spacing}
  \if@openright\cleardoublepage\else\clearpage\fi 
  \phantomsection%
  \addcontentsline{toc}{chapter}%
    {\texorpdfstring{\Makeuppercase{Vita}}{Vita}}
  \chapter*{\MakeUppercase{Vita}}
  \@mkboth{\scshape\MakeUppercase{Vita}}%
          {\scshape\MakeUppercase{Vita}}%
  \vskip 0.5in
  \begingroup
}{\par\endgroup}%Vita

\newcommand{\beforepostface}{%
  \pagestyle{\back@pagestyle}
}%

%
%% \postfacesection is here for backward compatibility with
%% the GT-thesis.sty package, and to add postface sections
%% that are not already defined.  (Appendices are not postface
%% material).  Currently, the only predefined postface section
%% is Vita.  Use \begin{vita}...\end{vita}.  (``Index'' is a 
%% postface section, but: it is defined in the add-on style
%% gatech-thesis-index.sty, and it doesn't use \postfacesection.)
%
\newcommand{\postfacesection}[1]{%
  \newlinestretch{\@spacing}
  \if@openright\cleardoublepage\else\clearpage\fi 
  % must clear page here, so that phantomsection\addcontentsline is on the correct page
  \phantomsection%
  \addcontentsline{toc}{chapter}%
    {\texorpdfstring{\Makeuppercase{#1}}{#1}}
  \chapter*{\MakeUppercase{#1}}
  \@mkboth{\scshape\MakeUppercase{#1}}%
          {\scshape\MakeUppercase{#1}}%
  \pagestyle{\back@pagestyle}
  \vskip 0.5in
}
\newcommand{\afterpostface}{
   \settocdepth{\chapter@tocdepth}%
   \pagestyle{\body@pagestyle}
}
\newcommand{\refname}{References}
\newcommand{\references}{%
  \ifbibpage
    \typeout{*****************     References    ******************}
    \newlinestretch{1.0}%
    \if@openright\cleardoublepage\else\clearpage\fi 
    % must clear page here, so that phantomsection\addcontentsline is on the correct page
    %\phantomsection%
    \addcontentsline{toc}{chapter}%
      {\texorpdfstring{\Makeuppercase{\refname}}{\refname}}
%    \bibliographystyle{gatech-thesis}
    %\begin{doublespaced}
    \bibliography{\@bibfiles}
    %\end{doublespaced}
  \fi
}

%%%%%%%%%   BIBLIOGRAPHY %%%%%%%%%%%%%%%%%
%%
%% redefine ``thebibliography'' environment so that title conforms to Georgia
%% Tech format (all caps, center of page)
%%
\renewenvironment{thebibliography}[1]{
  { \chapter*{\normalsize{\textbf{\refname}}}
    \@mkboth{\scshape\MakeUppercase\refname}%
            {\scshape\MakeUppercase\refname}%
    \pagestyle{\body@pagestyle}% REFERENCES uses BODY pagestyle, not endmatter.
    %\vskip -0.25in
    \vspace*{-0.25in}
  }
  \list{\@biblabel{\@arabic\c@enumiv}}%
  { \settowidth\labelwidth{\@biblabel{#1}}%
	%\addtocounter{page}{0} 
	%\phantomsection%
	\addcontentsline{toc}{chapter}%
	{\texorpdfstring{\textbf{References}}{References}}
      \leftmargin\labelwidth
      \advance\leftmargin\labelsep
      \@openbib@code
      \usecounter{enumiv}%
      \let\p@enumiv\@empty
      \renewcommand\theenumiv{\@arabic\c@enumiv}
  }%
  \newlinestretch{1.0}%
  \sloppy
  \clubpenalty4000
  \@clubpenalty \clubpenalty
  \widowpenalty4000%
  \sfcode`\.\@m}
  {\def\@noitemerr
     {\@latex@warning{Empty ``thebibliography'' environment}
  \pagestyle{\back@pagestyle}
  }%
  \endlist
}

%
%% Variations of \cleardoublepage that explicitly set the pagestyle
%% of any inserted blank page.
%
\newcommand{\clearemptydoublepage}%
  {{\pagestyle{empty}\cleardoublepage}}
\newcommand{\clearplaindoublepage}%
  {{\pagestyle{plain}\cleardoublepage}}
\newcommand{\cleartcplaindoublepage}%
  {{\pagestyle{tcplain}\cleardoublepage}}
\newcommand{\cleargtthesisdoublepage}%
  {{\pagestyle{gtthesis}\cleardoublepage}}

\newcommand{\setfrontpagestyle}[1]{%
  \gdef\front@pagestyle{#1}
}
\newcommand{\setbodypagestyle}[1]{%
  \gdef\body@pagestyle{#1}
}
\newcommand{\setbackpagestyle}[1]{%
  \gdef\back@pagestyle{#1}
}

%%%%%%    Page Styles
%
%% Redefine all four standard page styles (empty, plain, headings,
%% myheadings), based on the definitions in ``report'', so that they
%% conform to the GSO guidelines (and include draft information if
%% applicable).
%%
%% Also, define a new pagestyle ``tcplain'' which is just like ``plain'',
%% but puts page numbers in header (left/right 2page, or right 1page)
%% instead of at the bottom of the page.
%%
%% Then, define a new pagestyle ``gtthesis''. I like this one better
%% but the Graduate Studies Office doesn't. :-(
%
\renewcommand{\ps@empty}{
  \@tcpagefalse
  \let\@mkboth\@gobbletwo
  \def\@oddfoot{
    \if@draft
      \blDRAFT\hfil
      {\slshape\small\today}\hfil\brDRAFT
    \fi
  }%
  \let\@evenfoot\@oddfoot
  \def\@oddhead{
    \if@draft
      \tlDRAFT\hfil
      {\slshape\small\today}\hfil\trDRAFT
    \fi
  }%
  \let\@evenhead\@oddhead
}%ps@empty

%
%% Pagestyle ``plain''.
%
\renewcommand{\ps@plain}{%
  \@tcpagefalse%
  \let\@mkboth\@gobbletwo%
  \def\@oddfoot{%
    \if@draft\blDRAFT\fi%
    \hfil\thepage\hfil%
    \if@draft\brDRAFT\fi%
  }%
  \let\@evenfoot\@oddfoot%
  \def\@oddhead{%
    \if@draft%
      \tlDRAFT\hfil%
      {\slshape\small\today}\hfil\trDRAFT%
    \fi%
  }%
  \let\@evenhead\@oddhead%
}%ps@plain

%
%% Pagestyle ``headings''.
%
\if@twoside % if two-sided printing
  \renewcommand{\ps@headings}{%
    \@tcpagefalse%
    \let\@mkboth\markboth%
    \def\@oddfoot{%
      \if@draft%
        \blDRAFT\hfil%
        {\slshape\small\today}\hfil\brDRAFT%
      \fi%
    }%
    \let\@evenfoot\@oddfoot%
    \def\@oddhead{%
      \if@draft\tlDRAFT\fi%
      {\slshape\rightmark}\hfil%
      \thepage%
      \if@draft\trDRAFT\fi%
    }%
    \def\@evenhead{%
      \if@draft\tlDRAFT\fi%
      \thepage\hfil%
      {\slshape\leftmark}%
      \if@draft\trDRAFT\fi%
    }%
    \def\chaptermark##1{%
      \markboth
      {\textbf{%
        \ifnum\c@secnumdepth >\m@ne%
          \@chapapp\ \thechapter. \ %
        \fi ##1}%
      }{}%
    }%
    \def\sectionmark##1{%
      \markright%
      {\textbf{%
        \ifnum\c@secnumdepth >\z@%
          \thesection. \ %
        \fi ##1}%
      }%
    }%
  }%ps@headings
\else % if one-sided printing
  \renewcommand{\ps@headings}{%
    \@tcpagefalse%
    \let\@mkboth\markboth%
    \def\@oddfoot{%
      \if@draft%
        \blDRAFT\hfil%
        {\slshape\small\today}\hfil\brDRAFT%
      \fi%
    }%
    \def\@oddhead{%
      \if@draft\tlDRAFT\fi%
      {\slshape\rightmark}\hfil%
      \thepage%
      \if@draft\trDRAFT\fi%
    }%
    \def\chaptermark##1{%
      \markright%
      {\MakeUppercase{%
        \ifnum\c@secnumdepth >\m@ne%
          \@chapapp\ \thechapter. \ %
        \fi ##1}%
      }%
    }%
  }%ps@headings
\fi % @twoside

%
%% Pagestyle ``myheadings''.
%
\renewcommand{\ps@myheadings}{%
  \@tcpagefalse%
  \let\@mkboth\@gobbletwo%
  \def\@oddfoot{%
    \if@draft%
      \blDRAFT\hfil%
      {\slshape\small\today}\hfil\brDRAFT%
    \fi%
   }%
   \let\@evenfoot\@oddfoot%
   \def\@oddhead{%
     \if@draft\tlDRAFT\fi%
     {\slshape\rightmark}\hfil%
     \thepage%
     \if@draft\trDRAFT\fi%
   }%
   \def\@evenhead{%
     \if@draft\tlDRAFT\fi%
     \thepage\hfil%
     {\slshape\leftmark}%
     \if@draft\trDRAFT\fi%
   }%
   \let\chaptermark\@gobble\let\sectionmark\@gobble%
}%ps@myheadings

%
%% Pagestyle ``gtthesis'' (based on ``headings'').
%
\if@twoside % if two-sided printing
  \newcommand{\ps@gtthesis}{%
    \@tcpagetrue%
    \let\@mkboth\markboth%
    \def\@oddfoot{%
      \if@draft%
        \blDRAFT\hfil%
        {\slshape\small\today}\hfil\brDRAFT%
      \fi%
    }%
    \let\@evenfoot\@oddfoot%
    \def\@oddhead{%
      \if@draft\tlDRAFT\fi%
      {\slshape\rightmark}\hfil%
      \thepage%
      \if@draft\trDRAFT\fi%
    }%
    \def\@evenhead{%
      \if@draft\tlDRAFT\fi%
      \thepage\hfil%
      {\slshape\leftmark}%
      \if@draft\trDRAFT\fi%
    }%
    \def\chaptermark##1{%
      \markboth%
      {\textsc{%
        \ifnum\c@secnumdepth >\m@ne%
          \@chapapp\ \thechapter. \ %
        \fi ##1}%
      }{}%
    }%
    \def\sectionmark##1{%
      \markright%
      {\textsc{%
        \ifnum\c@secnumdepth >\z@%
          \thesection. \ %
        \fi ##1}%
      }
    }%
  }%ps@gtthesis
\else % if one-sided printing
  \newcommand{\ps@gtthesis}{%
    \@tcpagetrue%
    \let\@mkboth\markboth%
    \def\@oddfoot{%
      \if@draft%
        \blDRAFT\hfil%
        {\slshape\small\today}\hfil\brDRAFT%
      \fi%
    }%
    \def\@oddhead{%
      \if@draft\tlDRAFT\fi%
      {\slshape\rightmark}\hfil%
      \thepage%
      \if@draft\trDRAFT\fi%
    }%
    \def\chaptermark##1{%
      \markright%
      {\textsc{%
        \ifnum\c@secnumdepth >\m@ne%
          \@chapapp\ \thechapter. \ %
        \fi ##1}%
      }
    }%
  }%ps@gtthesis
\fi % @twoside

%
%% Pagestyle ``tcplain'' (based on ``plain'').
%
\if@twoside % if two-sided printing
  \newcommand{\ps@tcplain}{%
    \@tcpagetrue%
    \let\@mkboth\markboth%
    \def\@oddfoot{%
      \if@draft%
        \blDRAFT\hfil%
        {\slshape\small\today}\hfil\brDRAFT%
      \fi%
    }%
    \let\@evenfoot\@oddfoot%
    \def\@oddhead{%
      \if@draft\tlDRAFT\fi%
      \hfil\thepage%
      \if@draft\trDRAFT\fi%
    }%
    \def\@evenhead{%
      \if@draft\tlDRAFT\fi%
      \thepage\hfil%
      \if@draft\trDRAFT\fi%
    }%
  }%ps@tcplain
\else % if one-sided printing
  \newcommand{\ps@tcplain}{%
    \@tcpagetrue%
    \let\@mkboth\markboth%
    \def\@oddfoot{%
      \if@draft%
        \blDRAFT\hfil%
        {\slshape\small\today}\hfil\brDRAFT%
      \fi%
    }%
    \def\@oddhead{%
      \if@draft\tlDRAFT\fi%
      \hfil\thepage%
      \if@draft\trDRAFT\fi%
    }%
  }%ps@tcplain
\fi % @twoside


%%%%%%    Document Layout
%
%% Default line spacing: use current setting from options.
%
\linespacing{\@thesislnsp}
%
%% Page layout (see The LaTeX Companion pp.84-86).
%
%% By default, TeX puts the ``reference point'' one inch down and to
%% the right of the top-left corner of the page.  This moves it back
%% to the top-left corner (making the rest of the layout easier to
%% define).
%
\setlength{\voffset}{-1in}
\setlength{\hoffset}{-1in}
%
%% Instead of hard-coding the page layout for letter paper
%% (8.5" x 11"), we will base it on \paperheight and \paperwidth,
%% so that it works with options that change the paper size.
%
\setlength{\textheight}{\paperheight}
\setlength{\textwidth}{\paperwidth}
%
%% Now, set the margin-dependent values.
%
\ifcase\@marginsize % set narrow margins: 1 1/4" left, 3/4" others
%
\addtolength{\textheight}{-1.5in}
\setlength{\topmargin}{.5in}
\setlength{\headsep}{.25in}
\setlength{\footskip}{.25in}
\addtolength{\textwidth}{-2in}
\setlength{\oddsidemargin}{1.25in}
\setlength{\evensidemargin}{.75in}
\setlength{\marginparwidth}{.5in}
\setlength{\marginparsep}{.125in}
%
\or % set normal margins: 1.5 " left, 1" others (modified 01/27/01)
%
\addtolength{\textheight}{-2in}
\setlength{\topmargin}{0.5in}
\setlength{\headsep}{0.5in}
\setlength{\footskip}{0.5in}
\addtolength{\textwidth}{-2.25in}
\setlength{\oddsidemargin}{1.25in}
\setlength{\evensidemargin}{0.75in}
\setlength{\marginparwidth}{.5in}
\setlength{\marginparsep}{.125in}
%
\or % set wide margins: 1.5" left, 1" others, 2"" top (modified 01/14/00)
%
\addtolength{\textheight}{-3in}
\setlength{\topmargin}{1in}
\setlength{\headsep}{.5in} % reduced by headheight, below
\setlength{\footskip}{0.5in}
\addtolength{\textwidth}{-2.5in}
\setlength{\oddsidemargin}{1.5in}
\setlength{\evensidemargin}{1in}
\setlength{\marginparwidth}{.75in}
\setlength{\marginparsep}{.125in}
%
\or % set extra wide margins: 1 1/2"" all around
%
\addtolength{\textheight}{-3in}
\setlength{\topmargin}{1in}
\setlength{\headsep}{.5in}
\setlength{\footskip}{.5in}
\addtolength{\textwidth}{-3in}
\setlength{\oddsidemargin}{1.5in}
\setlength{\evensidemargin}{1.5in}
\setlength{\marginparwidth}{1in}
\setlength{\marginparsep}{.25in}
%
\or % use oldmargin (OLD GT): 1.5" left and top, 1" others (modified 01/27/01)
%
\addtolength{\textheight}{-2.5in}
\setlength{\topmargin}{0.75in}
\setlength{\headsep}{0.75in}   % reduced by headheight, below
\setlength{\footskip}{0.5in}
\addtolength{\textwidth}{-2.5in}
\setlength{\oddsidemargin}{1.5in}
\setlength{\evensidemargin}{1in}
\setlength{\marginparwidth}{.75in}
\setlength{\marginparsep}{.125in}
%
\or % set normal margins: 1.25 " left, 1" others (modified 04/04/18)
%
\addtolength{\textheight}{-2in}
\setlength{\topmargin}{0.5in}
\setlength{\headsep}{0.5in}
\setlength{\footskip}{0.5in}
\addtolength{\textwidth}{-2.in}
\setlength{\oddsidemargin}{1.25in}
\setlength{\evensidemargin}{0.75in}
\setlength{\marginparwidth}{.5in}
\setlength{\marginparsep}{.125in}
%
\fi%@marginsize
%
%% Adjust \headsep to include height of running head.
%
\addtolength{\headsep}{-\headheight}
%
%% Adjust the vertical spacing between the main text and the notes,
%% and between successive notes if they are not single-spaced.
%
\setlength{\skip\footins}{.75\baselineskip}
\if@singlespacednotes
\else
  \let\oldtextsize=\currenttextsize
  \footnotesize
  \setlength{\marginparpush}{\baselineskip}
  \setlength{\footnotesep}{\baselineskip}
  \oldtextsize
\fi % @singlespacednotes
%
%% \flushbottom looks silly with lots of extra space between paragraphs
%% better to put the "extra" space at the bottom of the page!
%
\raggedbottom
%
%% Default page style.
%
\pagestyle{plain}
\setfrontpagestyle{plain}
\setbodypagestyle{plain}
\setbackpagestyle{plain}

%
%% Number subsubsections
%
\setcounter{secnumdepth}{5}

%
%% Show subsubsections in table of contents
%% tocdepth is reset to the value in \setchaptertocdepth
%%   at each \chapter{}, or to the value in \setappendixtocdepth
%%   at each \chapter{} after the \appendix command.  So, if 
%%   you want to change the defaults, use \setchaptertocdepth and 
%%   \setappendixtocdepth.  To temporarily change depth for the 
%%   current section, use a different function: \settocdepth[x].  
%%   You should never need to call \setcounter{tocdepth}{..} 
%%   directly.
%%
%% 0 = chapter only
%% 1 = chapter + sections
%% 2 = chapter, section, subsection
%% 3 = chapter, section, subsection, subsubsection
%
\setcounter{tocdepth}{5} % we call setcounter{tocdepth}{} directly here
                         % but user .tex files should not do this.
% We must insure that the last \setcounter command in the .toc 
% file is NON-ZERO, or the listoffigures and listoftables become 
% empty.  Bad news. Unfortunately, that means we must do some
% raw TeXing here...
%   You would think the \end{postliminary} code would fix this, and it
% does -- but only if you don't \include your vita.  \input{vita} 
% works great because the \end{postliminary} code causes 
% \setcounter{tocdepth}{NONZERO} to be written.  But, if you 
% \include{vita} (or whatever the LAST section before \end{postliminary} 
% is) and the \setcounter command from \end{postliminary} does NOT get 
% written to the .aux file.  Fooey.  This is our workaround.
%   BUT, do NOT remove the one from \end{postliminary}.  When
% \input{vita}, THAT one gets used, and not this one!  Clearly,
% a LaTeX bug.
\AtEndDocument{%
  \immediate\write\@auxout%
  {\string\@writefile{toc}{\string\setcounter{tocdepth}{5}}}
  \clearpage\lastpage@putlabel}%

\setchaptertocdepth{1}
\setappendixtocdepth{0}

%% Disallow page breaks at hyphens (this will give some underfull vbox's,
%% so an alternative is to use \brokenpenalty=100 and manually search
%% for and fix such page breaks)
%
\brokenpenalty=10000
\InputIfFileExists{gatech-thesis-patch.sty}{}{}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  End of GATECH-THESIS.CLS
%%
%%  license information is in the COPYING file.  The copyright notice 
%%  therein applies to the license itself, not to this file: the GNU 
%%  PUBLIC LICENSE is copyrighted by the Free Software Foundation.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
